% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_get_query_results}
\alias{athena_get_query_results}
\title{Returns the results of a single query execution specified by
QueryExecutionId if you have access to the workgroup in which the query
ran}
\usage{
athena_get_query_results(QueryExecutionId, NextToken, MaxResults)
}
\arguments{
\item{QueryExecutionId}{[required] The unique ID of the query execution.}

\item{NextToken}{The token that specifies where to start pagination if a previous request
was truncated.}

\item{MaxResults}{The maximum number of results (rows) to return in this request.}
}
\description{
Returns the results of a single query execution specified by
\code{QueryExecutionId} if you have access to the workgroup in which the
query ran. This request does not execute the query but returns results.
Use StartQueryExecution to run a query.
}
\section{Request syntax}{
\preformatted{svc$get_query_results(
  QueryExecutionId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
