% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_user}
\alias{quicksight_describe_user}
\title{Returns information about a user, given the user name}
\usage{
quicksight_describe_user(UserName, AwsAccountId, Namespace)
}
\arguments{
\item{UserName}{[required] The name of the user that you want to describe.}

\item{AwsAccountId}{[required] The ID for the AWS account that the user is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Returns information about a user, given the user name.
}
\details{
The permission resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> }.

The response is a user object that contains the user's Amazon Resource
Name (ARN), AWS Identity and Access Management (IAM) role, and email
address.

\strong{CLI Sample:}

\code{aws quicksight describe-user --aws-account-id=111122223333 --namespace=default --user-name=Pat }
}
\section{Request syntax}{
\preformatted{svc$describe_user(
  UserName = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
