% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_create_cluster}
\alias{kafka_create_cluster}
\title{Creates a new MSK cluster}
\usage{
kafka_create_cluster(BrokerNodeGroupInfo, ClientAuthentication,
  ClusterName, ConfigurationInfo, EncryptionInfo, EnhancedMonitoring,
  KafkaVersion, NumberOfBrokerNodes, Tags)
}
\arguments{
\item{BrokerNodeGroupInfo}{[required]
<p>Information about the broker nodes in the cluster.</p>}

\item{ClientAuthentication}{<p>Includes all client authentication related information.</p>}

\item{ClusterName}{[required]
<p>The name of the cluster.</p>}

\item{ConfigurationInfo}{<p>Represents the configuration that you want MSK to use for the brokers in a cluster.</p>}

\item{EncryptionInfo}{<p>Includes all encryption-related information.</p>}

\item{EnhancedMonitoring}{<p>Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER.</p>}

\item{KafkaVersion}{[required]
<p>The version of Apache Kafka.</p>}

\item{NumberOfBrokerNodes}{[required]
<p>The number of broker nodes in the cluster.</p>}

\item{Tags}{<p>Create tags when creating the cluster.</p>}
}
\description{
<p>Creates a new MSK cluster.</p>
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  BrokerNodeGroupInfo = list(
    BrokerAZDistribution = "DEFAULT",
    ClientSubnets = list(
      "string"
    ),
    InstanceType = "string",
    SecurityGroups = list(
      "string"
    ),
    StorageInfo = list(
      EbsStorageInfo = list(
        VolumeSize = 123
      )
    )
  ),
  ClientAuthentication = list(
    Tls = list(
      CertificateAuthorityArnList = list(
        "string"
      )
    )
  ),
  ClusterName = "string",
  ConfigurationInfo = list(
    Arn = "string",
    Revision = 123
  ),
  EncryptionInfo = list(
    EncryptionAtRest = list(
      DataVolumeKMSKeyId = "string"
    ),
    EncryptionInTransit = list(
      ClientBroker = "TLS"|"TLS_PLAINTEXT"|"PLAINTEXT",
      InCluster = TRUE|FALSE
    )
  ),
  EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER",
  KafkaVersion = "string",
  NumberOfBrokerNodes = 123,
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
