% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patLanRGB.R
\name{patLanRGB}
\alias{patLanRGB}
\title{Aligns images usings transformations obtained from fixed landmarks and extracts colors
using a predefined RGB values and cutoff value.}
\usage{
patLanRGB(
  sampleList,
  landList,
  RGB = NULL,
  sampleRGB = FALSE,
  sampleRGBtype = "point",
  resampleFactor = NULL,
  colOffset = 0.1,
  crop = FALSE,
  cropOffset = c(0, 0, 0, 0),
  res = 300,
  transformRef = "meanshape",
  transformType = "tps",
  adjustCoords = FALSE,
  plot = NULL,
  focal = FALSE,
  sigma = 3,
  iterations = 0,
  imageIDs = NULL,
  patternsToFile = NULL
)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{landList}{Landmark list as returned by \code{\link[patternize]{makeList}}.}

\item{RGB}{RGB values for color pattern extraction specified as vector.}

\item{sampleRGB}{Whether to set RGB for each image manually.}

\item{sampleRGBtype}{Whether to pick a point or area (defined by left bottom and top right)
for sampleRGB.}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}}.}

\item{colOffset}{Color offset for color pattern extraction (default = 0.10).}

\item{crop}{Whether to use the landmarks range to crop the image. This can speed up the
analysis (default = FALSE).}

\item{cropOffset}{Vector c(xmin, xmax, ymin, ymax) that specifies the number of pixels you
want the cropping to be offset from the landmarks (in case the landmarks do not surround
the entire color pattern). The values specified should present the percentage of the maximum
landmark value along the x and y axis.}

\item{res}{Resolution for color pattern raster (default = 300). This should be reduced if
the number of pixels in the image is lower than th raster.}

\item{transformRef}{ID of reference sample for shape to which color patterns will be transformed
to. Can be 'meanshape' for transforming to mean shape of Procrustes analysis.}

\item{transformType}{Transformation type as used by \code{\link[Morpho]{computeTransform}}
(default ='tps').}

\item{adjustCoords}{Adjust landmark coordinates in case they are reversed compared to pixel
coordinates (default = FALSE).}

\item{plot}{Whether to plot transformed color patterns while processing (default = NULL).
Transformed color patterns can be plot on top of each other ('stack') or next to the
original image for each sample ('compare').}

\item{focal}{Whether to perform Gaussian blurring (default = FALSE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 3).}

\item{iterations}{Number of iterations for recalculating average color.}

\item{imageIDs}{A list of IDs to match landmarks to images if landmarkList and imageList don't
have the same length.}

\item{patternsToFile}{Name of directory to which the color pattern of each individual will be
outputted (default = NULL).}
}
\value{
List of raster objects.
}
\description{
Aligns images usings transformations obtained from fixed landmarks and extracts colors
using a predefined RGB values and cutoff value.
}
\examples{

\dontrun{
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '_landmarks_LFW.txt'

landmarkList <- makeList(IDlist, 'landmark', prepath, extension)

extension <- '.jpg'
imageList <- makeList(IDlist, 'image', prepath, extension)

RGB <- c(114,17,0)
rasterList_lanRGB <- patLanRGB(imageList, landmarkList, RGB,
colOffset = 0.15, crop = TRUE, res = 100, adjustCoords = TRUE, plot = 'stack')
}

}
