% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcAccuracy.R
\name{pcAccuracy}
\alias{pcAccuracy}
\title{Calculate Pattern Causality Accuracy}
\usage{
pcAccuracy(
  dataset,
  E,
  tau,
  metric = "euclidean",
  h,
  weighted,
  distance_fn = NULL,
  state_space_fn = NULL,
  verbose = FALSE
)
}
\arguments{
\item{dataset}{A matrix or data frame where each column represents a time series}

\item{E}{Integer; embedding dimension for state space reconstruction (E > 1)}

\item{tau}{Integer; time delay for state space reconstruction (tau > 0)}

\item{metric}{Character; distance metric to use, one of "euclidean", "manhattan", or "maximum"}

\item{h}{Integer; prediction horizon, indicating forecast distance (h >= 0)}

\item{weighted}{Logical; whether to use weighted approach in calculating causality strengths}

\item{distance_fn}{Optional custom distance function for computing distances (default: NULL)}

\item{state_space_fn}{Optional custom function for state space reconstruction (default: NULL)}

\item{verbose}{Logical; whether to display progress information (default: FALSE)}
}
\value{
An object of class "pc_accuracy" containing:
\itemize{
\item parameters: List of input parameters (E, tau, metric, h, weighted)
\item total: Mean total causality across all pairs
\item positive: Mean positive causality across all pairs
\item negative: Mean negative causality across all pairs
\item dark: Mean dark causality across all pairs
\item matrices: Raw causality matrices for each type
}
}
\description{
Evaluates the causality prediction accuracy across multiple time series
within a dataset using the PC Mk. II Light method. This function analyzes pairwise
causality relationships and computes different types of causality measures.
}
\details{
Calculate Pattern Causality Accuracy
}
\examples{
\donttest{
data(climate_indices)
data <- climate_indices[, -1]
results <- pcAccuracy(dataset = data, E = 3, tau = 1, 
                     metric = "euclidean", h = 1, 
                     weighted = TRUE, verbose = TRUE)
print(results)
}

}
\seealso{
\code{\link{pcMatrix}} for analyzing individual causality matrices
\code{\link{pcLightweight}} for pairwise causality analysis
}
