% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pastNNsInfo_Lite.R
\name{pastNNsInfo_Lite}
\alias{pastNNsInfo_Lite}
\title{Finding Nearest Neighbors and Keeping their Topological Information (Lite Version)}
\usage{
pastNNsInfo_Lite(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
}
\arguments{
\item{CCSPAN}{Integer, the span of common coordinates to exclude from the nearest neighbor search (not used in Lite version).}

\item{NNSPAN}{Integer, the number of nearest neighbors to consider for the analysis.}

\item{Mx}{Matrix, the main matrix representing the state space of the system.}

\item{Dx}{Numeric matrix, containing distances between points in the state space.}

\item{SMx}{Matrix, containing signatures of the state space.}

\item{PSMx}{Matrix, containing patterns derived from the signatures.}

\item{i}{Integer, the current index in time series data for which nearest neighbors are being considered.}

\item{h}{Integer, the horizon beyond which data is not considered in the nearest neighbor search (not used in Lite version).}
}
\value{
A list containing:
\itemize{
\item \code{i}: The current index in time series data.
\item \code{times}: The times of the nearest neighbors.
\item \code{dists}: The distances to the nearest neighbors.
\item \code{signatures}: The signatures of the nearest neighbors.
\item \code{patterns}: The patterns of the nearest neighbors.
\item \code{coordinates}: The coordinates of the nearest neighbors.
}
}
\description{
This function is a simplified version of \code{pastNNsInfo}, identifying the nearest neighbors of a given point in a time series. It returns detailed information about these neighbors, including their times, distances, signatures, patterns, and coordinates, without excluding common coordinate vectors and horizon.
}
\examples{
# Generate random data for demonstration
set.seed(123)
E <- 3
tau <- 1
Mx <- matrix(rnorm(200), nrow = 20)
CCSPAN <- (E - 1) * tau
NNSPAN <- E + 1
i <- 15
h <- 2
Dx <- distanceVector(point = Mx[i, ], candidateNNs = Mx[1:(i - CCSPAN - h), ], n = 2)
SMx <- signatureSpace(Mx, E)
PSMx <- patternSpace(SMx, E)
neighborsInfoLite <- pastNNsInfo_Lite(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
print(neighborsInfoLite)
}
