% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_snw_functions.R
\name{visualize_active_subnetworks}
\alias{visualize_active_subnetworks}
\title{Visualize Active Subnetworks}
\usage{
visualize_active_subnetworks(
  active_snw_path,
  genes_df,
  pin_name_path = "Biogrid",
  num_snws,
  layout = "stress",
  score_quan_thr = 0.8,
  sig_gene_thr = 0.02,
  ...
)
}
\arguments{
\item{active_snw_path}{path to the output of an Active Subnetwork Search}

\item{genes_df}{the input data that was used with \code{\link{run_pathfindR}}.
  It must be a data frame with 3 columns: \enumerate{
  \item Gene Symbol (Gene Symbol)
  \item Change value, e.g. log(fold change) (optional)
  \item p value, e.g. adjusted p value associated with differential expression
} The change values in this data frame are used to color the affected genes}

\item{pin_name_path}{Name of the chosen PIN or path/to/PIN.sif. If PIN name,
must be one of c("Biogrid", "STRING", "GeneMania", "IntAct", "KEGG", "mmu_STRING"). If
path/to/PIN.sif, the file must comply with the PIN specifications. (Default = "Biogrid")}

\item{num_snws}{number of top subnetworks to be visualized (leave blank if
you want to visualize all subnetworks)}

\item{layout}{The type of layout to create (see \code{\link[ggraph]{ggraph}} for details. Default = "stress")}

\item{score_quan_thr}{active subnetwork score quantile threshold. Must be
between 0 and 1 or set to -1 for not filtering. (Default = 0.8)}

\item{sig_gene_thr}{threshold for the minimum proportion of significant genes in
the subnetwork (Default = 0.02) If the number of genes to use as threshold is
calculated to be < 2 (e.g. 50 signif. genes x 0.01 = 0.5), the threshold number
is set to 2}

\item{...}{additional arguments for \code{\link{input_processing}}}
}
\value{
a list of ggplot objects of graph visualizations of identified active
subnetworks. Green nodes are down-regulated genes, reds are up-regulated genes
and yellows are non-input genes
}
\description{
Visualize Active Subnetworks
}
\examples{
path2snw_list <- system.file("extdata/resultActiveSubnetworkSearch.txt",
                              package = "pathfindR")
# visualize top 2 active subnetworks
g_list <- visualize_active_subnetworks(active_snw_path = path2snw_list,
                                       genes_df = RA_input[1:10, ],
                                       pin_name_path = "KEGG",
                                       num_snws = 2)
}
