% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{annotate_pathway_DEGs}
\alias{annotate_pathway_DEGs}
\title{Annotate the Affected Genes in the Provided Pathways}
\usage{
annotate_pathway_DEGs(result_df, input_processed, gene_sets = "KEGG",
  custom_genes = NULL)
}
\arguments{
\item{result_df}{data frame of enrichment results. The only must-have column is "ID".}

\item{input_processed}{input data processed via `input_processing`}

\item{gene_sets}{the gene sets used for enrichment analysis. Possible gene sets
are KEGG, Reactome, BioCarta, GO-All, GO-BP, GO-CC, GO-MF or Custom (Default = "KEGG"). If "Custom", the
custom_genes argument must be specified.}

\item{custom_genes}{a list containing the genes involved in each custom gene set. Each element
is a vector of gene symbols located in the given pathway. Names correspond to
the ID of the pathway.}
}
\value{
The original data frame with two additional columns:  \describe{
  \item{Up_regulated}{Up-regulated input genes in the given pathway}
  \item{Down_regulated}{Down-regulated input genes in the given pathway}
}
}
\description{
Annotate the Affected Genes in the Provided Pathways
}
\examples{
example_gene_data <- RA_input
colnames(example_gene_data) <- c("GENE", "CHANGE", "P_VALUE")

annotated_result <- annotate_pathway_DEGs(RA_output, example_gene_data)

}
