/*
 * Decompiled with CFR 0.152.
 */
package Network;

import Network.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Network {
    private HashMap<Node, HashSet<Node>> adjacency = new HashMap();

    public void addInteraction(String strNode1, String strNode2) {
        Node node1 = new Node(strNode1);
        Node node2 = new Node(strNode2);
        this.addInteraction(node1, node2);
    }

    public void addInteraction(Node node1, Node node2) {
        if (node1.equals(node2)) {
            Logger.getLogger(Network.class.getName()).log(Level.WARNING, "Self interaction discarded");
        } else {
            if (this.adjacency.get(node1) == null) {
                this.adjacency.put(node1, new HashSet());
            }
            if (this.adjacency.get(node2) == null) {
                this.adjacency.put(node2, new HashSet());
            }
            this.adjacency.get(node1).add(node2);
            this.adjacency.get(node2).add(node1);
        }
    }

    public HashSet<Node> getNeighborSet(Node node) {
        return this.adjacency.get(node);
    }

    public ArrayList<Node> getNodeList() {
        return new ArrayList<Node>(this.adjacency.keySet());
    }

    public boolean areAdjacent(Node node1, Node node2) {
        return this.adjacency.get(node1).contains(node2);
    }

    public int getNumberOfNodes() {
        return this.adjacency.keySet().size();
    }

    public int getNumberOfInteractions() {
        int interactionNumber = 0;
        ArrayList<Node> nodeList = this.getNodeList();
        for (int i = 0; i < nodeList.size() - 1; ++i) {
            for (int j = i + 1; j < nodeList.size(); ++j) {
                if (!this.areAdjacent(nodeList.get(i), nodeList.get(j))) continue;
                ++interactionNumber;
            }
        }
        return interactionNumber;
    }
}

