% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RA_clustered}
\alias{RA_clustered}
\title{Example Output for the pathfindR Clustering Workflow - Rheumatoid Arthritis}
\format{A data frame with 33 rows and 8 columns:
\describe{
  \item{ID}{KEGG ID of the enriched pathway}
  \item{Pathway}{Description of the enriched pathway}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched pathway}
  \item{occurrence}{the number of iterations that the given pathway was found to enriched over all iterations}
  \item{lowest_p}{the lowest adjusted-p value of the given pathway over all iterations}
  \item{highest_p}{the highest adjusted-p value of the given pathway over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Cluster}{the cluster to which the pathway is assigned}
  \item{Status}{whether the pathway is the "Representative" pathway in its cluster or only a "Member"}
}}
\usage{
RA_clustered
}
\description{
A dataset containing the results of pathfindR's pathway clustering and
partitioning  workflow performed on the rheumatoid arthritis
enrichment results \code{RA_output}. The number of clusters were detected
automatically as 11 and the agglomeration method was "average".
}
\seealso{
\code{\link{RA_input}} for example input of the enrichment workflow.
\code{\link{RA_output}} for example output of the enrichment workflow.
}
\keyword{datasets}
