% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-dsl.R
\name{with_qfuns}
\alias{with_qfuns}
\title{With qry_funs}
\usage{
with_qfuns(code)
}
\arguments{
\item{code}{Code to evaluate. See example.}
}
\value{
The result of \code{code} - i.e., your query.
}
\description{
This function evaluates whatever code you pass to it in the environment of
the \code{\link{qry_funs}} list. This allows you to cut down on typing when
writing your queries. If you want to cut down on typing even more, you can
try assigning the \code{\link{qry_funs}} list into your global environment
with: \code{list2env(qry_funs, envir = globalenv())}.
}
\examples{
# Without with_qfuns, we have to do:
qry_funs$and(
  qry_funs$gte(patent_date = "2007-01-01"),
  qry_funs$text_phrase(patent_abstract = c("computer program")),
  qry_funs$or(
    qry_funs$eq(inventor_last_name = "ihaka"),
    qry_funs$eq(inventor_first_name = "chris")
  )
)

#...With it, this becomes:
with_qfuns(
 and(
   gte(patent_date = "2007-01-01"),
   text_phrase(patent_abstract = c("computer program")),
   or(
     eq(inventor_last_name = "ihaka"),
     eq(inventor_first_name = "chris")
   )
 )
)

}
