% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_region_series.R
\name{sample_region_series}
\alias{sample_region_series}
\title{Sample points from a region time series}
\usage{
sample_region_series(x, size, method = "random", replace = FALSE, na.rm = TRUE)
}
\arguments{
\item{x}{a \code{terra::SpatRasterDataset} returned
by \code{region_series}}

\item{size}{number of points sampled. A single value is used to sample the same
locations across all time steps, a vector of values to sample different locations
at each time step.}

\item{method}{one of the sampling methods from \code{terra::spatSample}. It
defaults to "random"}

\item{replace}{boolean determining whether we sample with replacement}

\item{na.rm}{boolean determining whether NAs are removed}
}
\value{
a data.frame with the sampled cells and their respective values for
the climate variables.
}
\description{
This function samples points from a region time series. Sampling can either be
performed for the same locations at all time steps (if only one value is given
for `size`), or for different locations for each time step (if `size` is a 
vector of length equal to the number of time steps). To sample the same
number of points, but different locations, for each time step, provide a vector
repeating the same value for each time step.
}
\details{
This function wraps \code{terra::spatSample} to appropriate sample the
\code{terra::SpatRaster}s in the \code{terra::SpatRasterDataset} returned
by \code{region_series}.
}
