% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_country_name.R
\name{as_country_name}
\alias{as_country_name}
\title{Convert standardized country codes to country names}
\usage{
as_country_name(x, to = "en", from = "iso2c", short = TRUE,
  variant = FALSE, factor = is.factor(x))
}
\arguments{
\item{x}{A character, factor, or numeric vector of country codes or names}

\item{to}{Language code of country names desired. Defaults to \code{"en"};
see \code{\link{codes}} for more options.}

\item{from}{Code format from which to convert. Defaults to \code{"iso2c"};
see \code{\link{codes}} for more options.}

\item{short}{Whether to use short alternative name when available. Can be
length 1 or the same length as \code{x}.}

\item{variant}{Whether to use variant alternative name when available. Can
be length 1 or the same length as \code{x}.}

\item{factor}{If \code{TRUE}, returns factor instead of character vector. If not
supplied, defaults to \code{is.factor(x)}}
}
\value{
A character or factor vector of country names. Warns if new \code{NA}
values are added.
}
\description{
\code{as_country_name} converts a vector of standardized country codes to
country names.
}
\details{
\code{as_country_name} takes a character, factor, or numeric vector of country
codes (or names in another standardized format) and converts them to
country names in the specified format. If you are trying to standardize an
existing set of names, see \code{\link[=parse_country]{parse_country()}}.

The default \code{"en"} is
from \href{http://cldr.unicode.org/}{Unicode Common Locale Data Repository (CLDR)},
which \href{http://cldr.unicode.org/translation/country-names}{aspires to use the most customary name}
e.g. "Switzerland" instead of official ones, which are frequently awkward for
common usage, e.g. "Swiss Confederation". CLDR also supplies names in a huge
variety of languages, allowing for easy translation. Short and variant
alternates are available for some countries; if not, the function will fall
back to the standard form. See LICENSE file for terms of use.

Other name sets are available from
\itemize{
\item \href{https://unstats.un.org/unsd/methodology/m49/}{the UN Statistics Division(UNSD)},
which maintains standardized names in English, Chinese, Russian, French,
Spanish, and Arabic, here named as \code{"en_un"} etc.
\item \href{https://www.iso.org/home.html}{the ISO}, \code{"en_iso"} and \code{"fr_iso"}, and
\item \href{https://www.cia.gov/library/publications/the-world-factbook/fields/2142.html#af}{the CIA World Factbook}:
\itemize{
\item \code{"en_cia"}, which include many longer official forms and shorter
practical forms,
\item \code{"en_cia_local"}, which includes transliterations, and
\item \code{"en_cia_abbreviation"}, which includes commonly-used abbreviations.
}
}

See \code{\link{codes}} for all options, or run \code{DT::datatable(codes)} for a
searchable widget.
}
\examples{
# Usable names for tough-to-standardize places
as_country_name(c("US", "TW", "MM", "XK", "KR"))

# If passed a factor, will return a releveled one
as_country_name(factor(c("US", "NF", "CD", "SJ")), short = FALSE, variant = TRUE)

# Speaks a lot of languages, knows a lot of codes
as_country_name(c("SAH", "PCN", "OMA", "JPN"), from = "fifa", to = "cy")    # to Welsh

}
\seealso{
For converting standardized names to codes, use \code{\link[=as_country_code]{as_country_code()}}.
For standardizing names to codes, use \code{\link[=parse_country]{parse_country()}}.
}
