% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_coercion.R
\name{as.parttime}
\alias{as.parttime}
\title{Coerce an object to a parttime object}
\usage{
as.parttime(x, ..., format = parse_iso8601_datetime, on.na = "warning")
}
\arguments{
\item{x}{an object for coersion}

\item{...}{Additional arguments passed to \code{format} when a function is
provided.}

\item{format}{a \code{function} or \code{character} value. If a
\code{function}, it should accept a character vector and return a matrix of
parttime components. If a \code{character} it should provide a regular
exprssion which contains capture groups for each of the parttime
components.  See \link{parse_to_parttime_matrix}'s \code{regex} parameter
for more details.}

\item{on.na}{a \code{function} used to signal a condition for new \code{NA} values
introduced by coercion, a \code{character} value among \code{"error"}, \code{"warning"} or
\code{"suppress"} (for silencing messages) or \code{NULL} equivalent to \code{"suppress"}.}
}
\value{
\code{parttime} vector. See the Details section of \link{parttime} for
further information.
}
\description{
Coerce an object to a parttime object
}
\examples{
as.parttime(c("1985-10-18", "1991-08-23", "1996-09-26"))
# <partial_time<YMDhmsZ>[3]>
# [1] "1985-10-18" "1991-08-23" "1996-09-26"

as.parttime(c("1234", "5678"), format = "(?<year>\\\\d{4})")
# <partial_time<YMDhmsZ>[2]>
# [1] "1234" "5678"

# format function that returns a matrix of components
utf8_str <- function(x) intToUtf8(utf8ToInt(x) - 16)
as.parttime(c("B@", "B@A@"), format = function(x) cbind(year = sapply(x, utf8_str)))
# <partial_time<YMDhmsZ>[2]>
# [1] "2000" "2010"

# format function that returns a parttime object by first pre-processing input
as.parttime("B@BB", format = function(x) as.parttime(utf8_str(x)))
# <partial_time<YMDhmsZ>[1]>
# [1] "2022"

# format function that returns a parttime object by manual construction
as.parttime("AIII", format = function(x) parttime(year = as.numeric(utf8_str(x))))
# <partial_time<YMDhmsZ>[1]>
# [1] "1999"

}
