% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{kulczynski}
\alias{kulczynski}
\alias{kulczynski,Partition,Partition-method}
\alias{kulczynski,PairCoefficients,missing-method}
\title{Kulczynski Index}
\usage{
kulczynski(p, q)

\S4method{kulczynski}{Partition,Partition}(p, q)

\S4method{kulczynski}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Kulczynski index
\deqn{\frac{1}{2} \left(\frac{N_{11}}{N_{21}} + \frac{N_{11}}{N_{12}} \right)}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(kulczynski(new("Partition", c(0, 0, 0, 1, 1)), 
                            new("Partition", c(0, 0, 1, 1, 1))), 0.5))

}
\references{
\insertRef{Kulczynski1927}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
