% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_area_clusters}
\alias{plot_area_clusters}
\alias{plot_stacked_area_clusters}
\alias{plot_ncluster}
\alias{plot_information}
\title{Plot partitions}
\usage{
plot_area_clusters(.data, partitioner = part_icc(),
  information = seq(0.1, 0.5, length.out = 25), ...,
  obs_color = "#E69F00", perm_color = "#56B4E9")

plot_stacked_area_clusters(.data, partitioner = part_icc(),
  information = seq(0.1, 0.5, length.out = 25), ...,
  stack_colors = c("#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2",
  "#D55E00"))

plot_ncluster(.partition, show_n = 100, fill = "#0172B1", color = NA,
  labeller = "target information:")

plot_information(.partition, fill = "#0172B1", color = NA,
  geom = ggplot2::geom_density)
}
\arguments{
\item{.data}{a data.frame to partition}

\item{partitioner}{a \code{partitioner}. See the \code{part_*()} functions and
\code{\link[=as_partitioner]{as_partitioner()}}.}

\item{information}{a vector of minimum information to fit in \code{\link[=partition]{partition()}}}

\item{...}{arguments passed to \code{\link[=partition]{partition()}}}

\item{obs_color}{the color of the observed partition}

\item{perm_color}{the color of the permuted partition}

\item{stack_colors}{the colors of the cluster sizes}

\item{.partition}{either a \code{partition} or a \code{tibble}, the result of
\code{\link[=map_partition]{map_partition()}} or \code{\link[=test_permutation]{test_permutation()}}}

\item{show_n}{the number of reduced variables to plot}

\item{fill}{the color of the fill for \code{geom}}

\item{color}{the color of the \code{geom}}

\item{labeller}{the facet label}

\item{geom}{the \code{geom} to use. The default is \code{geom_density}.}
}
\value{
a ggplot
}
\description{
\code{plot_stacked_area_clusters()} and \code{plot_area_clusters()} plot the partition
against a permuted partition. \code{plot_ncluster()} plots the number of
variables per cluster. If \code{.partition} is the result of \code{\link[=map_partition]{map_partition()}} or
\code{\link[=test_permutation]{test_permutation()}}, \code{plot_ncluster()} facets the plot by each \code{partition}.
\code{plot_information()} plots a histogram or density plot of the information of
each variable in the \code{partition}. If \code{.partition} is the result of
\code{\link[=map_partition]{map_partition()}} or \code{\link[=test_permutation]{test_permutation()}}, \code{plot_information()} plots a
scatterplot of the targeted vs. observed information with a 45 degree line
indicating perfect alignment.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

df \%>\%
  partition(.6, partitioner = part_pc1()) \%>\%
  plot_ncluster()

}
