% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcoords.R
\name{parcoords}
\alias{parcoords}
\title{Interactive 'd3.js' Parallel Coordinates Chart}
\usage{
parcoords(data = NULL, rownames = TRUE, color = NULL,
  brushMode = NULL, brushPredicate = "and", alphaOnBrushed = NULL,
  reorderable = FALSE, axisDots = NULL, margin = NULL,
  composite = NULL, alpha = NULL, queue = FALSE, mode = FALSE,
  rate = NULL, dimensions = NULL, bundleDimension = NULL,
  bundlingStrength = 0.5, smoothness = 0, tasks = NULL,
  autoresize = FALSE, withD3 = FALSE, width = NULL, height = NULL,
  elementId = NULL)
}
\arguments{
\item{data}{data.frame with data to use in the chart}

\item{rownames}{logical use rownames from the data.frame in the chart.  Regardless of
this parameter, we will append rownames to the data that we send to JavaScript.
If \code{rownames} equals \code{FALSE}, then we will use parallel coordinates
to hide it.}

\item{color}{Color can be a single color as rgb or hex.  For a color function,
provide a
\code{list( colorScale = , colorBy = , colorScheme =, colorInterpolator = , colorDomain =)}
where colorScale is the name of the
\href{https://github.com/d3/d3-scale/blob/master/README.md#sequential-scales}{d3-scale} such as
\code{scaleOrdinal} or \code{scaleSequential},
colorBy with the column name from the data to determine color.  If appplying color to a
discrete or ordinal variable then please also supply colorScheme, such as
\code{schemCategory10}.  If applying color
to a continuous variable then please also supply colorInterpolator
with colorInterpolator as the name of the \href{https://github.com/d3/d3-scale/blob/master/README.md#sequential_interpolator}{d3 interpolator},
such as \code{interpolateViridis}. If using a \code{d3}
color scale, then make sure to use the argument \code{withD3 = TRUE}.}

\item{brushMode}{string, either \code{"1D-axes"}, \code{"1D-axes-multi"},
or \code{"2D-strums"}
giving the type of desired brush behavior for the chart.}

\item{brushPredicate}{string, either \code{"and"} or \code{"or"} giving
the logic forthe join with multiple brushes.}

\item{alphaOnBrushed}{opacity from 0 to 1 when brushed (default to 0).}

\item{reorderable}{logical enable reordering of axes}

\item{axisDots}{logical mark the points where polylines meet an axis with dots}

\item{margin}{list of sizes of margins in pixels.  Currently
\code{brushMode = "2D-strums"} requires left margin = 0, so
this will change automatically and might result in unexpected
behavior.}

\item{composite}{foreground context's composite type}

\item{alpha}{opacity from 0 to 1 of the polylines}

\item{queue}{logical (default FALSE) to change rendering mode to queue for
progressive rendering.  Usually \code{ queue = T } for very large datasets.}

\item{mode}{string see\code{queue} above; \code{ queue = T } will set
\code{ mode = "queue" }}

\item{rate}{integer rate at which render will queue}

\item{dimensions}{\code{list} to customize axes dimensions}

\item{bundleDimension}{character string for the column or variable on which to bundle}

\item{bundlingStrength}{numeric value between 0 and 1 for the strength of the bundling.  This value will
not affect the parallel coordinates if \code{bundleDimension} is not set and will be ignored.}

\item{smoothness}{numeric value between between 0 and 1 for stength of smoothing or curvature.    This value will
not affect the parallel coordinates if \code{bundleDimension} is not set and will be ignored.}

\item{tasks}{a character string or \code{\link[htmlwidgets]{JS}} or list of
strings or \code{JS} representing a JavaScript function(s) to run
after the \code{parcoords} has rendered.  These provide an opportunity
for advanced customization.  Note, the \code{function} will use the
JavaScript \code{call} mechanism, so within the function, \code{this} will
be an object with {this.el} representing the containing element of the
\code{parcoords} and {this.parcoords} representing the \code{parcoords}
instance.}

\item{autoresize}{logical (default FALSE) to auto resize the parcoords
when the size of the container changes.  This is useful
in contexts such as rmarkdown slide presentations or
flexdashboard.  However, this will not be useful if you
expect bigger data or a more typical html context.}

\item{withD3}{\code{logical} to include d3 dependency from \code{d3r}. The 'parcoords'
htmlwidget uses a standalone JavaScript build and will
not include the entire d3 in the global/window namespace.  To include
d3.js in this way, use \code{withD3=TRUE}.}

\item{width}{integer in pixels defining the width of the widget.  Autosizing  to 100%
of the widget container will occur if \code{ width = NULL }.}

\item{height}{integer in pixels defining the height of the widget.  Autosizing to 400px
of the widget container will occur if \code{ height = NULL }.}

\item{elementId}{unique \code{CSS} selector id for the widget.}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents,
and within Shiny output bindings.
}
\description{
Create interactive parallel coordinates charts with this htmlwidget
wrapper for d3.js \href{https://github.com/bigfatdog/parcoords-es}{parallel-coordinates}.
}
\examples{
if(interactive()) {
  # simple example using the mtcars dataset
  data( mtcars )
  parcoords( mtcars )

  # various ways to change color
  #   in these all lines are the specified color
  parcoords( mtcars, color = "green" )
  parcoords( mtcars, color = "#f0c" )
  #   in these we supply a function for our color
  parcoords(
    mtcars
    , color = list(
       colorBy = "cyl"
       , colorScale = "scaleOrdinal"
       , colorScheme = "schemeCategory10"
    )
    , withD3 = TRUE
  )

  if(require('ggplot2', quietly = TRUE)) {
  parcoords(
    diamonds
    ,rownames = FALSE
    ,brushMode = "1d-axes"
    ,reorderable = TRUE
    ,queue = TRUE
    ,color= list(
       colorBy="cut"
       , colorScale = "scaleOrdinal"
       , colorScheme = "schemeCategory10"
    )
    ,withD3 = TRUE
  )
  }
}
library(parcoords)

parcoords(
  mtcars,
  dimensions = list(
    cyl = list(
      title = "cylinder",
      tickValues = unique(mtcars$cyl)
    )
  )
)

parcoords(
  mtcars
  ,rownames = FALSE
  ,brushMode = "1d-multi"
  ,brushPredicate = "OR"
  ,dimensions = list(
    cyl = list(
      title = "cylinder",
      tickValues = unique(mtcars$cyl)
    )
  )
)
}
