% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{interpolate_opts}
\alias{interpolate_opts}
\title{Interpolation Options}
\usage{
interpolate_opts(fun, kind = c("point", "integral"), ...)
}
\arguments{
\item{fun}{a function}

\item{kind}{a string; either "point" or "integral". How to interpret the
x, y values being interpolated. Either as point observations of a function OR
as the integral of the function over the interval.}

\item{...}{arbitrary other arguments, but checked against signature of \code{fun}}
}
\value{
a list, with \code{fun} and \code{kind} keys, as well as whatever other valid
keys appear in \code{...}.
}
\description{
Creates and interpolation options object for use with \code{\link[=alembic]{alembic()}}.
}
\details{
This method creates the interpolation object for use with \code{\link[=alembic]{alembic()}}; this
is a convenience method, which does basic validation on arguments and ensures
the information used in \code{\link[=alembic]{alembic()}} to do interpolation is available.

The \code{...} arguments will be provided to \code{fun} when it is invoked to
interpolate the tabular "functional" form of arguments to \code{\link[=alembic]{alembic()}}. If
\code{fun} has an argument \code{kind}, that parameter will also be passed when
invoking the function; if not, then the input data will be transformed to
\eqn{\{x, z\}} pairs, such that \eqn{x_{i+1}-x_{i} * z_i = y_i} - i.e., transforming to
a point value and a functional form which is assumed constant until the next
partition.
}
\examples{
interpolate_opts(
  fun = stats::splinefun, method = "natural", kind = "point"
)
interpolate_opts(
  fun = stats::approxfun, method = "constant", yleft = 0, yright = 0,
  kind = "integral"
)
}
