% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_wald.R, R/p_value_wald.R
\name{ci_wald}
\alias{ci_wald}
\alias{p_value_wald}
\alias{p_value_wald.merMod}
\title{Wald-test approximation for CIs and p-values}
\usage{
ci_wald(model, ci = 0.95, dof = NULL, component = c("all",
  "conditional", "zi", "zero_inflated"), robust = FALSE, ...)

p_value_wald(model, ...)

\method{p_value_wald}{merMod}(model, dof = Inf, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{dof}{Degrees of Freedom. If not specified, for \code{ci_wald()}, defaults to model's residual degrees of freedom (i.e. \code{n-k}, where \code{n} is the number of observations and \code{k} is the number of parameters). For \code{p_value_wald()}, defaults to \code{Inf}.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{robust}{Logical, if \code{TRUE}, robust standard errors are computed
by calling \code{\link[=standard_error_robust]{standard_error_robust()}}.
\code{standard_error_robust()}, in turn, calls one of the \code{vcov*()}-functions
from the \pkg{sandwich}-package for robust covariance matrix estimators.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed.}
}
\value{
The p-values.
}
\description{
The Wald-test approximation treats t-values as Wald z. Since the t distribution converges to the z distribution as degrees of freedom increase, this is like assuming infinite degrees of freedom. While this is unambiguously anti-conservative, this approximation appears as reasonable for reasonable sample sizes (Barr et al., 2013). That is, if we take the p-value to measure the probability of a false positive, this approximation produces a higher false positive rate than the nominal 5\% at p = 0.05.
}
\examples{
\donttest{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value_wald(model)
ci_wald(model, ci = c(0.90, 0.95))
}

}
\references{
Barr, D. J. (2013). Random effects structure for testing interactions in linear mixed-effects models. Frontiers in psychology, 4, 328.
}
