% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet.R
\name{ParameterSet}
\alias{ParameterSet}
\title{Parameter Set}
\description{
\code{ParameterSet} objects store parameters (\link{prm} objects) and add
internal validation checks and methods for:
\itemize{
\item Getting and setting parameter values
\item Transforming parameter values
\item Providing dependencies of parameters on each other
\item Tagging parameters, which may enable further properties
\item Storing subsets of parameters under prefixes
}
}
\examples{
library(set6)

## $value examples
p <- ParameterSet$new(list(prm(id = "a", support = Reals$new())))
p$values$a <- 2
p$values

## $trafo examples
p <- ParameterSet$new(list(prm(id = "a", 2, support = Reals$new())))
p$trafo

# simple transformation
p$get_values()
p$trafo <- function(x, self) {
 x$a <- exp(x$a)
 x
}
p$get_values()

# more complex transformation on tags
p <- ParameterSet$new(
  list(prm(id = "a", 2, support = Reals$new(), tags = "t1"),
       prm(id = "b", 3, support = Reals$new(), tags = "t1"),
       prm(id = "d", 4, support = Reals$new()))
)
# make sure `transform = FALSE` to prevent infinite recursion
p$trafo <- function(x, self) {
 out <- lapply(self$get_values(tags = "t1", transform = FALSE),
               function(.x) 2^.x)
 out <- c(out, list(d = x$d))
 out
}
p$get_values()


## ------------------------------------------------
## Method `ParameterSet$new`
## ------------------------------------------------

prms <- list(
 prm("a", Set$new(1), 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", 2, tags = "t2")
)
ParameterSet$new(prms)

## ------------------------------------------------
## Method `ParameterSet$print`
## ------------------------------------------------

prms <- list(
 prm("a", Set$new(1), 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", 2, tags = "t2")
)
p <- ParameterSet$new(prms)
p$print()
print(p)
p

## ------------------------------------------------
## Method `ParameterSet$get_values`
## ------------------------------------------------

prms <- list(
 prm("a", "reals", 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", tags = "t2")
)
p <- ParameterSet$new(prms)
p$trafo <- function(x, self) {
 x$a <- exp(x$a)
 x
}
p$get_values()
p$get_values(inc_null = FALSE)
p$get_values(id = "a")
p$get_values(tags = "t1")

## ------------------------------------------------
## Method `ParameterSet$add_dep`
## ------------------------------------------------

# not run as errors
\dontrun{
# Dependency on specific value
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$add_dep("a", "b", cnd("eq", 2))
# 'a' can only be set if 'b' equals 2
p$values$a <- 1
p$values <- list(a = 1, b = 2)

# Dependency on variable value
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$add_dep("a", "b", cnd("eq", id = "b"))
# 'a' can only be set if it equals 'b'
p$values$a <- 2
p$values <- list(a = 2, b = 2)
}

## ------------------------------------------------
## Method `ParameterSet$extract`
## ------------------------------------------------

# extract by id
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$extract("a")
# equivalently
p["a"]

# extract by prefix
prms <- list(
  prm("Pre1__par1", Set$new(1), 1, tags = "t1"),
  prm("Pre1__par2", "reals", 3, tags = "t2"),
  prm("Pre2__par1", Set$new(1), 1, tags = "t1"),
  prm("Pre2__par2", "reals", 3, tags = "t2")
)
p <- ParameterSet$new(prms)
p$extract(tags = "t1")
p$extract(prefix = "Pre1")
# equivalently
p[prefix = "Pre1"]
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{tags}}{None -> \code{named_list()} \cr
Get tags from the parameter set.}

\item{\code{ids}}{None -> \code{character()} \cr
Get ids from the parameter set.}

\item{\code{length}}{None -> \code{integer(1)} \cr
Get the length of the parameter set as the number of parameters.}

\item{\code{deps}}{None -> \link[data.table:data.table]{data.table::data.table}
Get parameter dependencies, NULL if none.}

\item{\code{supports}}{None -> \code{named_list()} \cr
Get supports from the parameter set.}

\item{\code{tag_properties}}{\code{list() -> self} / None -> \code{list()} \cr
If \code{x} is missing then returns tag properties if any. \cr
If \code{x} is not missing then used to tag properties. Currently properties
can either be: \cr
i) 'required' - parameters with this tag must have set (non-NULL)
values; if a parameter is both 'required' and 'linked' then exactly
one parameter in the 'linked' tag must be tagged;\cr
ii) 'linked' - parameters with 'linked' tags are dependent on one another
and only one can be set (non-NULL at a time);\cr
iii) 'unique' - parameters with this tag must have no duplicated
elements, therefore this tag only makes sense for vector parameters;\cr
iv) 'immutable' - parameters with this tag cannot be updated after
construction.}

\item{\code{values}}{\code{list() -> self} / None -> \code{list()} \cr
If \code{x} is missing then returns the set (non-NULL) values without
transformation or filtering; use \verb{$get_values} for a more sophisticated
getter of values. \cr
If \code{x} is not missing then used to set values of parameters, which are
first checked internally with the \verb{$check} method before setting the new
values. \cr
See examples at end.}

\item{\code{trafo}}{\verb{function()|list() -> self} / None -> \verb{function()|list()}
\cr
If \code{x} is missing then returns a transformation function if previously
set, a list of transformation functions, otherwise \code{NULL}. \cr
If \code{x} is not missing then it should either be:
\itemize{
\item a function with arguments \code{x} and \code{self}, which internally correspond
to \code{self} being the \code{ParameterSet} the transformation is being added to,
and \code{x <- self$values}.
\item a list of functions like above
}

The transformation function is automatically called after a call to
\code{self$get_values()} and is used to transform set values, it should
therefore result in a list. If using \code{self$get_values()} within the
transformation function, make sure to set \code{transform = FALSE} to prevent
infinite recursion, see examples at end.

It is generally safer to call the transformation with
\verb{$transform(self$values)} as this will first check to see if \verb{$trafo}
is a function or list. If the latter then each function in the list is
applied, one after the other.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ParameterSet$new()}}
\item \href{#method-print}{\code{ParameterSet$print()}}
\item \href{#method-get_values}{\code{ParameterSet$get_values()}}
\item \href{#method-add_dep}{\code{ParameterSet$add_dep()}}
\item \href{#method-rep}{\code{ParameterSet$rep()}}
\item \href{#method-extract}{\code{ParameterSet$extract()}}
\item \href{#method-remove}{\code{ParameterSet$remove()}}
\item \href{#method-getParameterValue}{\code{ParameterSet$getParameterValue()}}
\item \href{#method-setParameterValue}{\code{ParameterSet$setParameterValue()}}
\item \href{#method-set_values}{\code{ParameterSet$set_values()}}
\item \href{#method-parameters}{\code{ParameterSet$parameters()}}
\item \href{#method-transform}{\code{ParameterSet$transform()}}
\item \href{#method-clone}{\code{ParameterSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Constructs a \code{ParameterSet} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$new(prms = list(), tag_properties = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prms}}{(\code{list()}) \cr List of \link{prm} objects. Ids should be unique.}

\item{\code{tag_properties}}{(\code{list()}) \cr
List of tag properties. Currently supported properties are: i) 'required' -
parameters with this tag property must be non-NULL; ii) 'linked' - only one
parameter in a linked tag group can be non-NULL and the others should be
NULL, this only makes sense with an associated \code{trafo}; iii) 'unique' -
parameters with this tag must have no duplicated elements, only makes sense
for vector parameters; iv) 'immutable' - parameters with this tag cannot be
updated after construction.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{prms <- list(
 prm("a", Set$new(1), 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", 2, tags = "t2")
)
ParameterSet$new(prms)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the \code{ParameterSet} after coercion with
\link{as.data.table.ParameterSet}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$print(sort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sort}}{(\code{logical(1)}) \cr If \code{TRUE} (default) sorts the \code{ParameterSet}
alphabetically by id.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{prms <- list(
 prm("a", Set$new(1), 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", 2, tags = "t2")
)
p <- ParameterSet$new(prms)
p$print()
print(p)
p
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-get_values}{}}}
\subsection{Method \code{get_values()}}{
Gets values from the \code{ParameterSet} with options to filter
by specific IDs and tags, and also to transform the values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$get_values(
  id = NULL,
  tags = NULL,
  transform = TRUE,
  inc_null = TRUE,
  simplify = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character()}) \cr
If not NULL then returns values for given \code{ids}.}

\item{\code{tags}}{(\code{character()}) \cr
If not NULL then returns values for given \code{tags}.}

\item{\code{transform}}{(\code{logical(1)}) \cr
If \code{TRUE} (default) and \verb{$trafo} is not \code{NULL} then runs the set
transformation function before returning the values.}

\item{\code{inc_null}}{(\code{logical(1)}) \cr
If \code{TRUE} (default) then returns values for all ids even if \code{NULL}.}

\item{\code{simplify}}{(\code{logical(1)}) \cr
If \code{TRUE} (default) then unlists scalar values, otherwise always
returns a list.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{prms <- list(
 prm("a", "reals", 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", tags = "t2")
)
p <- ParameterSet$new(prms)
p$trafo <- function(x, self) {
 x$a <- exp(x$a)
 x
}
p$get_values()
p$get_values(inc_null = FALSE)
p$get_values(id = "a")
p$get_values(tags = "t1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_dep"></a>}}
\if{latex}{\out{\hypertarget{method-add_dep}{}}}
\subsection{Method \code{add_dep()}}{
Gets values from the \code{ParameterSet} with options to filter
by specific IDs and tags, and also to transform the values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$add_dep(id, on, cnd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)}) \cr
The dependent variable for the condition that depends on the given
variable, \code{on}, being a particular value. Should be in \code{self$ids}.}

\item{\code{on}}{(\code{character(1)}) \cr
The independent variable for the condition that is depended on by the
given variable, \code{id}. Should be in \code{self$ids}.}

\item{\code{cnd}}{(\code{cnd(1)}) \cr
The condition defined by \link{cnd} which determines how \code{id} depends on \code{on}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# not run as errors
\dontrun{
# Dependency on specific value
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$add_dep("a", "b", cnd("eq", 2))
# 'a' can only be set if 'b' equals 2
p$values$a <- 1
p$values <- list(a = 1, b = 2)

# Dependency on variable value
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$add_dep("a", "b", cnd("eq", id = "b"))
# 'a' can only be set if it equals 'b'
p$values$a <- 2
p$values <- list(a = 2, b = 2)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rep"></a>}}
\if{latex}{\out{\hypertarget{method-rep}{}}}
\subsection{Method \code{rep()}}{
Replicate the \code{ParameterSet} with identical parameters.
In order to avoid duplicated parameter ids, every id in the
\code{ParameterSet} is given a \code{prefix} in the format \code{prefix__id}. In
addition, linked tags are also given the same prefix to prevent
incorrectly linking parameters.

The primary use-case of this method is to treat the \code{ParameterSet} as a
collection of identical \code{ParameterSet} objects.

Note that this mutates the \code{ParameterSet}, if you want to instead create
a new object then use \link{rep.ParameterSet} instead (or copy and deep clone)
first.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$rep(times, prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{times}}{(\code{integer(1)}) \cr
Numer of times to replicate the \code{ParameterSet}.}

\item{\code{prefix}}{(\code{character(1)|character(length(times))}) \cr
The prefix to add to ids and linked tags. If length \code{1} then is
internally coerced to \code{paste0(prefix, seq(times))}, otherwise the length
should be equal to \code{times}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extract"></a>}}
\if{latex}{\out{\hypertarget{method-extract}{}}}
\subsection{Method \code{extract()}}{
Creates a new \code{ParameterSet} by extracting the given
parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$extract(id = NULL, tags = NULL, prefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character()}) \cr
If not \code{NULL} then specifies the parameters by id to extract. Should be
\code{NULL} if \code{prefix} is not \code{NULL}.}

\item{\code{tags}}{(\code{character()}) \cr
If not \code{NULL} then specifies the parameters by tag to extract. Should be
\code{NULL} if \code{prefix} is not \code{NULL}.}

\item{\code{prefix}}{(\code{character()}) \cr
If not \code{NULL} then extracts parameters according to their prefix and
additionally removes the prefix from the id. A prefix is determined as
the string before \code{"__"} in an id.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# extract by id
prms <- list(
 prm("a", "reals", NULL),
 prm("b", "reals", 1)
)
p <- ParameterSet$new(prms)
p$extract("a")
# equivalently
p["a"]

# extract by prefix
prms <- list(
  prm("Pre1__par1", Set$new(1), 1, tags = "t1"),
  prm("Pre1__par2", "reals", 3, tags = "t2"),
  prm("Pre2__par1", Set$new(1), 1, tags = "t1"),
  prm("Pre2__par2", "reals", 3, tags = "t2")
)
p <- ParameterSet$new(prms)
p$extract(tags = "t1")
p$extract(prefix = "Pre1")
# equivalently
p[prefix = "Pre1"]
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove"></a>}}
\if{latex}{\out{\hypertarget{method-remove}{}}}
\subsection{Method \code{remove()}}{
Removes the given parameters from the set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$remove(id = NULL, prefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character()}) \cr
If not \code{NULL} then specifies the parameters by id to extract. Should be
\code{NULL} if \code{prefix} is not \code{NULL}.}

\item{\code{prefix}}{(\code{character()}) \cr
If not \code{NULL} then extracts parameters according to their prefix and
additionally removes the prefix from the id. A prefix is determined as
the string before \code{"__"} in an id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getParameterValue"></a>}}
\if{latex}{\out{\hypertarget{method-getParameterValue}{}}}
\subsection{Method \code{getParameterValue()}}{
Deprecated method added for distr6 compatibility.
Use $values/$get_values() in the future.
Will be removed in 0.3.0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$getParameterValue(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Parameter id}

\item{\code{...}}{Unused}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setParameterValue"></a>}}
\if{latex}{\out{\hypertarget{method-setParameterValue}{}}}
\subsection{Method \code{setParameterValue()}}{
Deprecated method added for distr6 compatibility.
Use $set_values in the future.
Will be removed in 0.3.0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$setParameterValue(..., lst = list(...))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameter ids}

\item{\code{lst}}{List of parameter ids}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_values"></a>}}
\if{latex}{\out{\hypertarget{method-set_values}{}}}
\subsection{Method \code{set_values()}}{
Convenience function for setting multiple parameters
without changing or accidentally removing others.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$set_values(..., lst = list(...))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameter ids}

\item{\code{lst}}{List of parameter ids}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parameters"></a>}}
\if{latex}{\out{\hypertarget{method-parameters}{}}}
\subsection{Method \code{parameters()}}{
Deprecated method added for distr6 compatibility.
Use $print/as.data.table() in the future.
Will be removed in 0.3.0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$parameters(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Unused}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
Applies the internal transformation function.
If no function has been passed to \verb{$trafo} then \code{x} is returned
unchanged. If \verb{$trafo} is a function then \code{x} is passed directly to
this. If \verb{$trafo} is a list then \code{x} is evaluated and passed down the
list iteratively.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$transform(x = self$values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\verb{named list(1)}) \cr
List of values to transform.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{named list(1)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParameterSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
