% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setKeptColumns}
\alias{setKeptColumns}
\title{Column visibitity}
\usage{
setKeptColumns(id, keptColumns)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{keptColumns}{Vector of boolean (one for each data column), \code{FALSE} if column has to be hidden. A named list can also be provided to only indicate which columns must be assigned to a new visibility.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which columns have to be visible.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       checkboxInput("hideColumnsCB", "Hide last columns", FALSE),
       p("The check box controls the visibility of the two last columns"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(mtcars)
       })
       observeEvent(input$hideColumnsCB, {
           keptColumns <- sapply(1:ncol(mtcars), function(i) {
               return(ifelse(input$hideColumnsCB, ncol(mtcars) - i >= 2, TRUE))
           })
           parallelPlot::setKeptColumns("parPlot", keptColumns)
       })
   }

   shinyApp(ui, server)
 }

}
