% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamDbl.R
\docType{data}
\name{ParamDbl}
\alias{ParamDbl}
\title{Numerical Parameter}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Param}.}
\description{
A \link{Param} to describe real-valued parameters.
}
\section{Construction}{
\preformatted{ParamDbl$new(id, lower = -Inf, upper = Inf, special_vals = list(), default = NO_DEF, tags = character())
}

Arguments of \link{Param}, and additionally:
\itemize{
\item \code{lower} :: \code{numeric(1)}\cr
Lower bound, can be \code{-Inf}.
\item \code{upper} :: \code{numeric(1)}\cr
Upper bound can be \code{+Inf}.
}
}

\section{Fields}{

Fields of \link{Param}, and additionally:
\itemize{
\item \code{lower} :: \code{numeric(1)}\cr
Lower bound.
\item \code{upper} :: \code{numeric(1)}\cr
Upper bound.
\item \code{levels} :: \code{NULL}\cr
Allowed levels.
Always \code{NULL} for this parameter.
\item \code{nlevels} :: \code{Inf} \cr
Number of categorical levels.
Always \code{Inf} for this parameter.
\item \code{is_bounded} :: \code{logical(1)}\cr
Are the bounds finite?
}
}

\section{Methods}{

See \link{Param}.
}

\examples{
ParamDbl$new("ratio", lower = 0, upper = 1, default = 0.5)
}
\seealso{
Other Params: \code{\link{ParamFct}},
  \code{\link{ParamInt}}, \code{\link{ParamLgl}},
  \code{\link{ParamUty}}, \code{\link{Param}}
}
\concept{Params}
\keyword{datasets}
