% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvar-methods.R
\name{girf}
\alias{girf}
\alias{girf.pvargmm}
\title{Generalized Impulse Response Function}
\usage{
girf(model, n.ahead, ma_approx_steps)

\method{girf}{pvargmm}(model, n.ahead, ma_approx_steps)
}
\arguments{
\item{model}{A PVAR model}

\item{n.ahead}{Any stable AR() model has an infinite MA representation. Hence any shock can be simulated infinitely into the future. For each forecast step t you need an addtional MA term.}

\item{ma_approx_steps}{MA approximation steps}
}
\description{
Generalized Impulse Response Function
}
\examples{
data("ex1_dahlberg_data")
girf(ex1_dahlberg_data, n.ahead = 8, ma_approx_steps= 8)
}
