% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelsummary.R
\name{panelsummary}
\alias{panelsummary}
\title{Create a regression table with multiple panels}
\usage{
panelsummary(
  ...,
  panel_labels = NULL,
  mean_dependent = FALSE,
  colnames = NULL,
  caption = NULL,
  format = NULL,
  collapse_fe = FALSE,
  bold = FALSE,
  italic = FALSE,
  hline_after = FALSE,
  hline_before_fe = TRUE,
  fmt = 3,
  estimate = "estimate",
  statistic = "std.error",
  vcov = NULL,
  conf_level = 0.95,
  stars = FALSE,
  coef_map = NULL,
  coef_omit = NULL,
  coef_rename = NULL,
  gof_map = NULL,
  gof_omit = NULL
)
}
\arguments{
\item{...}{A regression model or models (see panelsummary::models_supported for classes that are supported).
* The regression model can be a list of models or a singular object.
* If a list is passed in, one column for each list is created. Each argument will correspond to a panel.
* If only one object is passed in, there will be no panels and the output will be similar to evaluating modelsummary::modelsummary() followed by kableExtra::kbl()}

\item{panel_labels}{A character vector. How to label each panel in the table.
* `NULL` (the default): the panels will be labeled "Panel A:", "Panel B:",...etc.}

\item{mean_dependent}{A boolean. For use with fixest objects only.
* `FALSE` (the default): the mean of the dependent variable will not be shown in the resulting table.
* `TRUE`: the mean of the dependent variable will be shown in the resulting table.}

\item{colnames}{An optional vector of strings. The vector of strings should have the same length as the number columns of the table.
* `NULL` (the default): colnames are defaulted to a whitespace, followed by (1), (2), ....etc.}

\item{caption}{A string. The table caption.}

\item{format}{A character string. Possible values are latex, html, pipe (Pandoc's pipe tables), simple (Pandoc's simple tables), and rst. The value of this argument will be automatically determined if the function is called within a knitr document. The format value can also be set in the global option knitr.table.format. If format is a function, it must return a character string.}

\item{collapse_fe}{A boolean. For use with fixest objects only. Determines whether fixed effects should only be included in the bottom of the table. This is suited for when each panel has the same models with the same fixed effects.
* `FALSE` (the default): fixed effects are shown in each panel.
* `TRUE`: fixed effects are shown only at the bottom of the final panel, separated by a horizontal line (see hline_before_fe)}

\item{bold}{A boolean. Determines whether the panel names should be in bold font.
* `FALSE` (the default): the panel names are not in bold.
* `TRUE`: the panel names are bolded}

\item{italic}{A boolean. Determines whether the panel names should be in italics.
* `FALSE` (the default): the panel names are not in italics.
* `TRUE`: the panel names will be in italics.}

\item{hline_after}{A boolean. Adds a horizontal line after the panel labels.
* `FALSE` (the default): there is not horizonal line after the panel labels.
* `TRUE`: a horizontal line will appear after the panel labels.}

\item{hline_before_fe}{A boolean. To be used only when collapse_fe = TRUE, and hence with fixest objects only. Adds a horizontal line before the fixed effects portion of the table.}

\item{fmt}{how to format numeric values: integer, user-supplied function, or \code{modelsummary} function.
\itemize{
\item Integer: Number of decimal digits
\item User-supplied functions:
\itemize{
\item Any function which accepts a numeric vector and returns a character vector of the same length.
}
\item \code{modelsummary} functions:
\itemize{
\item \code{fmt = fmt_significant(2)}: Two significant digits (at the term-level)
\item \code{fmt = fmt_decimal(digits = 2, pdigits = 3)}: Decimal digits for estimate and p values
\item \code{fmt = fmt_sprintf("\%.3f")}: See \code{?sprintf}
\item \code{fmt = fmt_term("(Intercept)" = 1, "X" = 2)}: Format terms differently
\item \code{fmt = fmt_statistic("estimate" = 1, "r.sqared" = 6)}: Format statistics differently.
\item \code{fmt = fmt_identity()}: unformatted raw values
}
\item string:
\item Note on LaTeX output: To ensure proper typography, all numeric entries are enclosed in the \verb{\\num{}} command, which requires the \code{siunitx} package to be loaded in the LaTeX preamble. This behavior can be altered with global options. See the 'Details' section.
}}

\item{estimate}{a single string or a character vector of length equal to the
number of models. Valid entries include any column name of
the data.frame produced by \code{get_estimates(model)}, and strings with curly braces compatible with the \code{glue} package format. Examples:
\itemize{
\item \code{"estimate"}
\item \code{"{estimate} ({std.error}){stars}"}
\item \code{"{estimate} [{conf.low}, {conf.high}]"}
}}

\item{statistic}{vector of strings or \code{glue} strings which select uncertainty
statistics to report vertically below the estimate. NULL omits all
uncertainty statistics.
\itemize{
\item "conf.int", "std.error", "statistic", "p.value", "conf.low", "conf.high", .
or any column name produced by \code{get_estimates(model)}
\item \code{glue} package strings with braces, with or without R functions, such as:
\itemize{
\item \code{"{p.value} [{conf.low}, {conf.high}]"}
\item \code{"Std.Error: {std.error}"}
\item `"{exp(estimate) * std.error}"
}
\item Numbers are automatically rounded and converted to strings. To apply functions to their numeric values, as in the last \code{glue} example, users must set \code{fmt=NULL}.
\item Parentheses are added automatically unless the string includes \code{glue} curly braces \code{{}}.
\item Some statistics are not supported for all models. See column names in \code{get_estimates(model)}, and visit the website to learn how to add custom statistics.
}}

\item{vcov}{robust standard errors and other manual statistics. The \code{vcov}
argument accepts six types of input (see the 'Details' and 'Examples'
sections below):
\itemize{
\item NULL returns the default uncertainty estimates of the model object
\item string, vector, or (named) list of strings. "iid", "classical", and "constant" are aliases for \code{NULL}, which returns the model's default uncertainty estimates. The strings "HC", "HC0", "HC1" (alias: "stata"), "HC2", "HC3" (alias: "robust"), "HC4", "HC4m", "HC5", "HAC", "NeweyWest", "Andrews", "panel-corrected", "outer-product", and "weave" use variance-covariance matrices computed using functions from the \code{sandwich} package, or equivalent method. The behavior of those functions can (and sometimes \emph{must}) be altered by passing arguments to \code{sandwich} directly from \code{modelsummary} through the ellipsis (\code{...}), but it is safer to define your own custom functions as described in the next bullet.
\item function or (named) list of functions which return variance-covariance matrices with row and column names equal to the names of your coefficient estimates (e.g., \code{stats::vcov}, \code{sandwich::vcovHC}, \code{function(x) vcovPC(x, cluster="country")}).
\item formula or (named) list of formulas with the cluster variable(s) on the right-hand side (e.g., ~clusterid).
\item named list of \code{length(models)} variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
\item a named list of length(models) vectors with names equal to the names of your coefficient estimates. See 'Examples' section below. Warning: since this list of vectors can include arbitrary strings or numbers, \code{modelsummary} cannot automatically calculate p values. The \code{stars} argument may thus use incorrect significance thresholds when \code{vcov} is a list of vectors.
}}

\item{conf_level}{numeric value between 0 and 1. confidence level to use for
confidence intervals. Setting this argument to \code{NULL} does not extract
confidence intervals, which can be faster for some models.}

\item{stars}{to indicate statistical significance
\itemize{
\item FALSE (default): no significance stars.
\item TRUE: +=.1, *=.05, **=.01, ***=0.001
\item Named numeric vector for custom stars such as \code{c('*' = .1, '+' = .05)}
\item Note: a legend will not be inserted at the bottom of the table when the \code{estimate} or \code{statistic} arguments use "glue strings" with \code{{stars}}.
}}

\item{coef_map}{character vector. Subset, rename, and reorder coefficients.
Coefficients omitted from this vector are omitted from the table. The order
of the vector determines the order of the table. \code{coef_map} can be a named
or an unnamed character vector. If \code{coef_map} is a named vector, its values
define the labels that must appear in the table, and its names identify the
original term names stored in the model object: \code{c("hp:mpg"="HPxM/G")}. See
Examples section below.}

\item{coef_omit}{integer vector or regular expression to identify which coefficients to omit (or keep) from the table. Positive integers determine which coefficients to omit. Negative integers determine which coefficients to keep. A regular expression can be used to omit coefficients, and perl-compatible "negative lookaheads" can be used to specify which coefficients to \emph{keep} in the table. Examples:
\itemize{
\item c(2, 3, 5): omits the second, third, and fifth coefficients.
\item c(-2, -3, -5): negative values keep the second, third, and fifth coefficients.
\item \code{"ei"}: omit coefficients matching the "ei" substring.
\item \code{"^Volume$"}: omit the "Volume" coefficient.
\item \code{"ei|rc"}: omit coefficients matching either the "ei" or the "rc" substrings.
\item \code{"^(?!Vol)"}: keep coefficients starting with "Vol" (inverse match using a negative lookahead).
\item \code{"^(?!.*ei)"}: keep coefficients matching the "ei" substring.
\item \code{"^(?!.*ei|.*pt)"}: keep coefficients matching either the "ei" or the "pt" substrings.
\item See the Examples section below for complete code.
}}

\item{coef_rename}{logical, named or unnamed character vector, or function
\itemize{
\item Logical: TRUE renames variables based on the "label" attribute of each column. See the Example section below.
\item Unnamed character vector of length equal to the number of coefficients in the final table, after \code{coef_omit} is applied.
\item Named character vector: Values refer to the variable names that will appear in the table. Names refer to the original term names stored in the model object. Ex: c("hp:mpg"="hp X mpg")
\item Function: Accepts a character vector of the model's term names and returns a named vector like the one described above. The \code{modelsummary} package supplies a \code{coef_rename()} function which can do common cleaning tasks: \code{modelsummary(model, coef_rename = coef_rename)}
}}

\item{gof_map}{rename, reorder, and omit goodness-of-fit statistics and other
model information. This argument accepts 4 types of values:
\itemize{
\item NULL (default): the \code{modelsummary::gof_map} dictionary is used for formatting, and all unknown statistic are included.
\item character vector: "all", "none", or a vector of statistics such as \code{c("rmse", "nobs", "r.squared")}. Elements correspond to colnames in the data.frame produced by \code{get_gof(model)}. The \code{modelsummary::gof_map} default dictionary is used to format and rename statistics.
\item NA: excludes all statistics from the bottom part of the table.
\item data.frame with 3 columns named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples' section below.
\item list of lists, each of which includes 3 elements named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples section below'.
}}

\item{gof_omit}{string regular expression (perl-compatible) used to determine which statistics to omit from the bottom section of the table. A "negative lookahead" can be used to specify which statistics to \emph{keep} in the table. Examples:
\itemize{
\item \code{"IC"}: omit statistics matching the "IC" substring.
\item \code{"BIC|AIC"}: omit statistics matching the "AIC" or "BIC" substrings.
\item \code{"^(?!.*IC)"}: keep statistics matching the "IC" substring.
}}
}
\value{
A kableExtra object that is instantly customizable by kableExtra's suite of functions.
}
\description{
`panelsummary` Creates a beautiful and customizable regression table with panels. This function is best used to summarize multiple dependent variables that are passed through the same regression models. This function returns a kableExtra object which can then be edited using kableExtra's suite of functions.
}
\examples{

# Panelsummary with lm -------------------------

reg_1 <- lm(mpg ~ hp + cyl, data = mtcars)
reg_2 <- lm(disp ~ hp + cyl, data = mtcars)

panelsummary(reg_1, reg_2, panel_labels = c("Panel A: MPG", "Panel B: Displacement"))


# Panelsummary with fixest -------------------------
\dontrun{
ols_1 <- mtcars |> fixest::feols(mpg ~  cyl | gear + carb, cluster = ~hp, nthreads = 2)

panelsummary(ols_1, ols_1, mean_dependent = TRUE,
            panel_labels = c("Panel A:MPG", "Panel B: DISP"),
            caption = "The effect of cyl on MPG and DISP",
            italic = TRUE, stars = TRUE)


## Collapsing fixed effects (fixest-only)----------------

panelsummary(ols_1, ols_1, mean_dependent = TRUE,
            collapse_fe = TRUE, panel_labels = c("Panel A: MPG", "Panel B: DISP"),
            caption = "The effect of cyl on MPG and DISP",
            italic = TRUE, stars = TRUE)

## Including multiple models------------------


panelsummary(list(ols_1, ols_1, ols_1), ols_1,
             panel_labels = c("Panel A: MPG", "Panel B: DISP"),
              caption = "Multiple models",
              stars = TRUE)

}
}
