% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandocfilters.R
\name{document}
\alias{document}
\title{Create a new Document}
\usage{
document()
}
\description{
A constructor of an object of type \code{"document"}.
}
\details{
Each document has the following methods:
\itemize{
  \item[] \code{to_json()}
     \itemize{ 
       \item[] \emph{Description}
       \item[] \itemize{ Returns the \code{JSON} representation of the document. } }
  \item[] \code{write(con, format="markdown", writer=pandocfilters_writer)}
     \itemize{ 
       \item[] \emph{Description}
       \item[] \itemize{\item[] Write the JSON-formatted AST to a connection.}
       \item[] \emph{Arguments}
       \item[] \itemize{\item[] \code{con}    \sspace a connection object or a character string to which the document is written  }
       \item[] \itemize{\item[] \code{format} \sspace a character string giving the format (e.g. \code{"latex"}, \code{"html"})  }
       \item[] \itemize{\item[] \code{writer} \sspace an optional writer function, see \link{pandocfilters_writer} }    
       \item[] \emph{Note}
       \item[] \itemize{\item[] Any function with the three arguments \code{x}, \code{con} and \code{format} can be used as writer function.}
     }
  \item[] \code{append(x)}
     \itemize{ 
       \item[] \emph{Description}
       \item[] \itemize{\item[] Append a new block to the document.}
       \item[] \emph{Arguments}
       \item[] \itemize{\item[] \code{x} \sspace a block object or list of block objects} }
  \item[] \code{append_plain(x)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Plain}. }
  \item[] \code{append_para(x)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Para}.}
  \item[] \code{append_code_block(attr, code)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{CodeBlock}.}
  \item[] \code{append_block_quote(blocks)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{BlockQuote}.}
  \item[] \code{append_ordered_list(lattr, lblocks)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{OrderedList}.}
  \item[] \code{append_bullet_list(lblocks)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{BulletList}.}
  \item[] \code{append_definition_list(x)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{DefinitionList}.}
  \item[] \code{append_header(x, level=1L, attr=Attr())} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Header}.}
  \item[] \code{append_horizontal_rule()} \sspace
     \itemize{ \item[] For more information about the arguments see \link{HorizontalRule}.}
  \item[] \code{append_table(rows, col_names=NULL, aligns=NULL, col_width=NULL, caption=list())} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Table}.}
  \item[] \code{append_div(blocks, attr)} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Div}.}
  \item[] \code{append_null()} \sspace
     \itemize{ \item[] For more information about the arguments see \link{Null}.}
}
}

