% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-run.R
\name{with_pandoc_version}
\alias{with_pandoc_version}
\alias{local_pandoc_version}
\title{Execute any code with a specific Pandoc version}
\usage{
with_pandoc_version(
  version,
  code,
  rmarkdown = getOption("pandoc.activate_rmarkdown", TRUE)
)

local_pandoc_version(
  version,
  rmarkdown = getOption("pandoc.activate_rmarkdown", TRUE),
  .local_envir = parent.frame()
)
}
\arguments{
\item{version}{This can be either:
\itemize{
\item \code{"latest"} for the latest release
\item A version number (e.g \code{"2.11.4"}) for a specific version
\item \code{"nightly"} for the last pandoc development built daily
}}

\item{code}{Code to execute with the temporary active Pandoc version.}

\item{rmarkdown}{if \code{TRUE} (the default) and \strong{rmarkdown} is available, this
will also set the pandoc version as the default one to use with
\strong{rmarkdown} by calling \code{\link[rmarkdown:find_pandoc]{rmarkdown::find_pandoc()}}. Default behavior can
be changed globally by setting option \code{pandoc.activate_rmarkdown}.}

\item{.local_envir}{The environment to use for scoping.}
}
\value{
The results of the evaluation of the \code{code} argument.
}
\description{
This function allows to run any R code by changing the active pandoc version to use
without modifying the R session state.
}
\details{
This is inspired from \strong{withr} package.
}
\examples{
\dontshow{if (!is.null(pandoc::pandoc_system_bin()) && pandoc_system_version() > 1.18) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Run with pandoc without activating the version for rmarkdown::render()
with_pandoc_version("system",
   pandoc_bin(),
   rmarkdown = FALSE
)
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.11.4") && rlang::is_installed("rmarkdown")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
with_pandoc_version("2.11.4", rmarkdown::find_pandoc(), rmarkdown = TRUE)
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive() && pandoc::pandoc_is_installed("2.11.4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
local({
  local_pandoc_version("2.11.4")
  pandoc::pandoc_locate()
  rmarkdown::find_pandoc()
})
rmarkdown::find_pandoc()
\dontshow{\}) # examplesIf}
}
