% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag-lead-utils.R
\name{gg_laglead}
\alias{gg_laglead}
\alias{gg_laglead.default}
\alias{gg_laglead.LL_df}
\alias{gg_laglead.nested_fdf}
\title{Plot Lag-Lead windows}
\usage{
gg_laglead(x, ...)

\method{gg_laglead}{default}(x, tz, ll_fun, ...)

\method{gg_laglead}{LL_df}(
  x,
  high_col = "grey20",
  low_col = "whitesmoke",
  grid_col = "lightgrey",
  ...
)

\method{gg_laglead}{nested_fdf}(x, ...)
}
\arguments{
\item{x}{Either a numeric vector of follow-up cut points or a suitable object.}

\item{...}{Further arguments passed to methods.}

\item{tz}{A vector of exposure times}

\item{ll_fun}{Function that specifies how the lag-lead matrix
should be constructed. First argument is the follow up time
second argument is the time of exposure.}

\item{high_col}{Color used to highlight exposure times within the lag-lead window.}

\item{low_col}{Color of exposure times outside the lag-lead window.}

\item{grid_col}{Color of grid lines.}
}
\description{
Given data defining a Lag-lead window, returns respective plot as a
\code{ggplot2} object.
}
\examples{
## Example 1: supply t, tz, ll_fun directly
 gg_laglead(1:10, tz=-5:5,
  ll_fun=function(t, tz) { t >= tz + 2 & t <= tz + 2 + 3})

## Example 2: extract information on t, tz, ll_from data with respective attributes
data("simdf_elra", package = "pammtools")
gg_laglead(simdf_elra)
}
\seealso{
get_laglead
}
