% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate.R
\name{bivariate}
\alias{bivariate}
\alias{stevens.pinkgreen}
\alias{stevens.bluered}
\alias{stevens.pinkblue}
\alias{stevens.greenblue}
\alias{stevens.purplegold}
\alias{brewer.orangeblue}
\alias{brewer.pinkblue}
\alias{tolochko.redblue}
\alias{arc.bluepink}
\alias{census.blueyellow}
\title{Bivariate palettes}
\usage{
stevens.pinkgreen(n = 9)

stevens.bluered(n = 9)

stevens.pinkblue(n = 9)

stevens.greenblue(n = 9)

stevens.purplegold(n = 9)

brewer.orangeblue(n = 9)

brewer.pinkblue(n = 9)

tolochko.redblue(n = 9)

arc.bluepink(n = 9)

census.blueyellow(n = 9)
}
\arguments{
\item{n}{Number of colors to return.}
}
\value{
A vector of colors as hex strings.
}
\description{
Color palettes designed for bivariate choropleth maps.
}
\details{
In each palette name, the color in the upper left corner is given first, and the color
in the lower right corner is given second.

The `arc.bluepink` palette uses white in the lower-left corner, which makes it
difficult to see the difference between low values and missing data on maps.

The `census.blueyellow` palette is slightly different, in that one direction
uses lightness, and the other direction uses hue (yellow, green, blue).
}
\examples{

bivcol <- function(pal){
  tit <- substitute(pal)
  pal <- pal()
  ncol <- length(pal)
  nx <- sqrt(length(pal))
  image(matrix(1:ncol, nrow=sqrt(ncol)), axes=FALSE, col=pal)
  mtext(tit)
}
op <- par(mfrow=c(3,4), mar=c(1,1,2,1))
bivcol(stevens.pinkgreen)
bivcol(stevens.bluered)
bivcol(stevens.pinkblue)
bivcol(stevens.greenblue)
bivcol(stevens.purplegold)
bivcol(brewer.orangeblue)
bivcol(brewer.pinkblue)
bivcol(tolochko.redblue)
bivcol(arc.bluepink)
bivcol(census.blueyellow)
par(op)

}
\references{
Joshua Stevens.
http://www.joshuastevens.net/cartography/make-a-bivariate-choropleth-map/

Cindy Brewer.
http://www.personal.psu.edu/cab38/ColorSch/SchHTMLs/CBColorSeqSeq.html

Robin Tolochko.
http://tolomaps.tumblr.com/post/131671267233/creating-a-bivariate-choropleth-color-scheme

Aileen Buckley.
https://www.slideshare.net/aileenbuckley/arc-gis-bivariate-mapping-tools-28903069

https://www.census.gov/population/www/cen2000/atlas/
Total Population, p. 4.
}
\author{
Palette colors by various authors. R code by Kevin Wright.
}
