% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-ns.r
\name{fit.twocamera}
\alias{fit.twocamera}
\title{Estimation of animal density from two-camera surveys.}
\usage{
fit.twocamera(points, cameras = NULL, d, w, b, l, tau, R,
  edge.correction = "pbc", start = NULL, bounds = NULL, trace = FALSE)
}
\arguments{
\item{points}{A vector (or single-column matrix) containing the
distance along the transect that each detection was made.}

\item{cameras}{An optional vector containing the camera ID (either
\code{1} or \code{2}) that made the corresponding detection in
\code{points}.}

\item{d}{The length of the transect flown (in km).}

\item{w}{The distance from the transect to which detection of
individuals on the surface is certain. This is equivalent to
the half-width of the detection zone.}

\item{b}{The distance from the transect to the edge of the area of
interest. Conceptually, the distance between the transect and
the furthest distance a whale could be on the passing of the
first camera and plausibly move into the detection zone by the
passing of the second camera.}

\item{l}{The lag between cameras (in seconds).}

\item{tau}{Mean dive-cycle duration (in seconds).}

\item{R}{Truncation distance (see \link{fit.ns}).}

\item{edge.correction}{The method used for the correction of edge
effects. Either \code{"pbc"} for periodic boundary conditions,
or \code{"buffer"} for a buffer-zone correction.}

\item{start}{A named vector of starting values for the model
parameters.}

\item{bounds}{A list with named components. Each component should
be a vector of length two, giving the upper and lower bounds
for the named parameter.}

\item{trace}{Logical, if \code{TRUE}, parameter values are printed
to the screen for each iteration of the optimisation procedure.}
}
\value{
An R6 reference class object. Extraction of the information
    held within is best handled by functions \link{coef.palm},
    \link{confint.palm}, \link{summary.palm}, and \link{plot.palm}.
}
\description{
Estimates animal density (amongst other parameters) from two-camera
aerial surveys. This conceptualises sighting locations as a
Neyman-Scott point pattern---estimation is carried out via
\code{fit.ns()}.
}
\details{
This function is simply a wrapper for \code{fit.ns}, and
facilitates the fitting of the model proposed by Stevenson,
Borchers, and Fewster (in prep). This function presents the
parameter \code{D.2D} (two-dimensional cetacean density in
cetaceans per square km) rather than \code{D} for enhanced
interpretability.
}
\examples{
fit <- fit.twocamera(points = example.twocamera$points, cameras = example.twocamera$cameras,
                    d = 500, w = 0.175, b = 0.5, l = 20, tau = 110, R = 1)

}
\references{
Stevenson, B. C., Borchers, D. L., and Fewster,
    R. M. (in prep) Trace-contrast methods to account for
    identification uncertainty on aerial surveys of cetacean
    populations.
}

