% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pbdb_strata}
\alias{pbdb_strata}
\title{pbdb_strata}
\usage{
pbdb_strata (...)
}
\arguments{
\item{...}{documentation for all the parameters
is available in http://paleobiodb.org/data1.1/strata/list
For example:
\code{name} A full or partial name. You can use %
and _ as wildcards,
but the query will be very slow if you put a wildcard
at the beginning
\code{rank} Return only strata of the specified rank:
formation, group or member.
\code{lngmin} numeric. The longitude boundaries will be normalized
to fall between -180 and 180. (Note that if you specify
lngmin then you must also specify lngmax).
Return only records whose geographic location falls
within the given bounding box (defined by lngmin, lngmax, latmin, latmax).
It generate two adjacent bounding boxes if the range crosses the antimeridian.
\code{lngmax} numeric. The longitude boundaries will be normalized
to fall between -180 and 180.
\code{latmin} numeric. between -90 and 90.
(Note that if you specify latmin then you must also specify latmax)
\code{latmax} numeric. between -90 and 90.
\code{loc} Return only strata associated with some occurrence whose geographic
location falls within the specified geometry, specified in WKT format.
\code{vocab} set vocab="pbdb" to show the complete name of the variables
(by default variables have short 3-letter names)}
}
\value{
a dataframe with information from the selected strata
}
\description{
Returns information about geological strata,
selected by name, rank, and/or geographic location.
}
\examples{
\dontrun{
pbdb_strata (lngmin=0, lngmax=15, latmin=0, latmax=15, rank="formation", vocab="pbdb")
}
}

