% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{fitSimple}
\alias{fitSimple}
\title{Fit simple models of trait evolution}
\usage{
fitSimple(
  y,
  model = c("GRW", "URW", "Stasis", "StrictStasis", "OU", "covTrack"),
  method = c("Joint", "AD"),
  pool = TRUE,
  z = NULL,
  hess = FALSE
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{model}{the model to be fit, one of \code{"GRW", "URW", "Stasis", "OU",
"covTrack"}}

\item{method}{parameterization to use: \code{Joint} or \code{AD}; see Details}

\item{pool}{if TRUE, sample variances are substituted with their pooled
estimate}

\item{z}{a vector of a covariate, used only for the "covTrack" model}

\item{hess}{if TRUE, standard errors computed from the Hessian matrix are
returned}
}
\value{
a \code{paleoTSfit} object with the model fitting results
}
\description{
Fit simple models of trait evolution
}
\details{
This is a convenience function that calls the specific individual
functions for each model and parameterization, such as \code{opt.GRW} and
\code{opt.joint.GRW}. The models that this function can fit are:
\itemize{
\item  \strong{GRW}: General Random Walk. Under this model, evolutionary
changes, or "steps" are drawn from a distribution with a mean of \code{mstep}
and variance of \code{vstep}.  \code{mstep} determines directionality and
\code{vstep} determines volatility (Hunt, 2006).
\item  \strong{URW}:
Unbiased Random Walk. Same as GRW with \code{mstep} = 0, and thus evolution
is non-directional. For a URW, \code{vstep} is the rate parameter.
\item \strong{Stasis}: This parameterization follows Sheets & Mitchell (2001), with
a constant mean \code{theta} and variance \code{omega} (equivalent to white
noise).
\item  \strong{Strict Stasis}: Same as Stasis with \code{omega} = 0,
indicating no real evolutionary differences; all observed variation is
sampling error (Hunt et al. 2015).
\item  \strong{OU}: Ornstein-Uhlenbeck
model (Hunt et al. 2008). This model is that of a population ascending a
nearby peak in the adaptive landscape. The optimal trait value is \code{theta},
\code{alpha} indicates the strength of attraction to that peak (= strength of
stabilizing selection around \code{theta}), \code{vstep} measures the random walk component (from genetic drift) and \code{anc} is the trait value
at the start of the sequence.
\item  \strong{covTrack}: Covariate-tracking (Hunt et al. 2010). The trait tracks
a covariate with slope \code{b1}, consistent with an adaptive response. \code{evar} is the
residual variance, and, under \code{method = "Joint"}, \code{b0} is the intercept of the
relationship between trait and covariate.
model. }
}
\note{
For the covariate-tracking model, z should be a vector of length
\emph{n} when \code{method = "Joint"} and \emph{n} - 1 when \code{method =
"AD"}, where \emph{n} is the number of samples in \code{y}. \cr \cr Method =
\code{"Joint"} is a full likelihood approach, considering each time-series as
a joint sample from a multivariate normal distribution.  Method = \code{"AD"}
is a REML approach that uses the differences between successive samples.
They perform similarly, but the Joint approach does better under some
circumstances (Hunt, 2008).
}
\examples{
y <- sim.Stasis(ns = 20, omega = 2)
w1 <- fitSimple(y, model = "GRW")
w2 <- fitSimple(y, model = "URW")
w3 <- fitSimple(y, model = "Stasis")
compareModels(w1, w2, w3)
}
\references{
Hunt, G. 2006. Fitting and comparing models of phyletic
evolution: random walks and beyond. \emph{Paleobiology} 32(4): 578-601. \cr
Hunt, G. 2008. Evolutionary patterns within fossil lineages: model-based
assessment of modes, rates, punctuations and process. p. 117-131 \emph{In}
From Evolution to Geobiology: Research Questions Driving Paleontology at the
Start of a New Century. Bambach, R. and P. Kelley (Eds). \cr Hunt, G., M. A.
Bell and M. P. Travis. 2008. Evolution toward a new adaptive optimum:
phenotypic evolution in a fossil stickleback lineage. \emph{Evolution} 62(3):
700-710. \cr Sheets, H. D., and C. Mitchell. 2010. Why the null matters:
statistical tests, random walks and evolution. \emph{Genetica} 112–
113:105–125. \cr
}
\seealso{
\code{\link{opt.GRW}}, \code{\link{opt.joint.GRW}},
  \code{\link{opt.joint.OU}}, \code{\link{opt.covTrack}}
}
