% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packcircles.R
\docType{package}
\name{packcircles-package}
\alias{packcircles}
\alias{packcircles-package}
\title{packcircles: Simple algorithms for circle packing}
\description{
This package provides several algorithms to find non-overlapping
arrangements of circles:
\describe{
 \item{circleRepelLayout}{Arranges circles within a bounding rectangle
   by pairwise repulsion.}
 \item{circleProgressiveLayout}{Arranges circles in an unbounded area
   by progressive placement. This is a very efficient algorithm that can
   handle large numbers of circles.}
 \item{circleGraphLayout}{Finds an arrangement of circles conforming to
   a graph specification.}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mbedward/packcircles}
  \item Report bugs at \url{https://github.com/mbedward/packcircles/issues}
}

}
\author{
\strong{Maintainer}: Michael Bedward \email{michael.bedward@gmail.com}

Authors:
\itemize{
  \item David Eppstein \email{david.eppstein@gmail.com} (Author of Python code for graph-based circle packing ported to C++ for this package)
  \item Peter Menzel \email{pmenzel@gmail.com} (Author of C code for progressive circle packing ported to C++ for this package)
}

}
