% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{set_package_info}
\alias{set_package_info}
\title{Set a Package's Info}
\usage{
set_package_info(
  path,
  author_at_r = getOption("packager")[["whoami"]],
  title = "What it Does (One Line, Title Case)",
  description = NULL,
  details = NA,
  ...
)
}
\arguments{
\item{path}{Path to the package.}

\item{author_at_r}{A \code{\link[utils:person]{person}} object.}

\item{title}{A string giving the title.}

\item{description}{A string giving the description.}

\item{details}{A string giving the details. Defaults to NA in which case a
default details are inserted. Set to NULL to have no details at all.}

\item{...}{Arguments to be passed to internal function
\code{packager:::use_intro}.}

\item{use_rasciidoc_vignette}{Set to FALSE to sticks with the classic
markdown vignette.}
}
\value{
\code{\link[base:invisible]{Invisibly}}
a list of results of setting the xxx-package.R and the DESCRIPTION.
}
\description{
Fill DESCRIPTION, R/xxx-package.R and an introductory vignette with the same 
Title, Description and possibly Details,
keeping the info given in different places identical.
}
\examples{
path <- file.path(tempdir(), "myPackage")
usethis::create_package(path = path, open = FALSE)
a  <- utils::person("Your", "Name", "some@whe.re", role = c("aut", "cre"))
set_package_info(path = path, author_at_r = a, title = "What Now?",
                 description = "This package does nothing.",
                 details = "Details do not show up in DESCRIPTION.")
package_desc <- file.path(path, "DESCRIPTION")
package_info_file <- file.path(path,
                               "R", paste0(basename(path), "-package.R"))
readLines(package_desc)
readLines(package_info_file)
unlink(path, recursive = TRUE)
}
\keyword{internal}
