% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageRank.R
\name{packageRank}
\alias{packageRank}
\title{Package download counts and rank percentiles.}
\usage{
packageRank(packages = "packageRank", date = NULL, all.filters = FALSE,
  ip.filter = FALSE, small.filter = FALSE, memoization = TRUE,
  check.package = TRUE, rank.ties = TRUE, multi.core = FALSE)
}
\arguments{
\item{packages}{Character. Vector of package name(s).}

\item{date}{Character. Date. "yyyy-mm-dd". NULL uses latest available log.}

\item{all.filters}{Logical. Master switch for filters.}

\item{ip.filter}{Logical.}

\item{small.filter}{Logical. TRUE filters out downloads less than 1000 bytes.}

\item{memoization}{Logical. Use memoization when downloading logs.}

\item{check.package}{Logical. Validate and "spell check" package.}

\item{rank.ties}{Logical. TRUE uses competition ranking ("1224") for ties. FALSE uses nominal rank (no ties).}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. Mac and Unix only.}
}
\value{
An R data frame.
}
\description{
From Posit/RStudio's CRAN Mirror (CDN) http://cran-logs.rstudio.com/
}
\examples{
\dontrun{
packageRank(packages = "cholera", date = "2020-01-01")
packageRank(packages = c("h2o", "Rcpp", "rstan"), date = "2020-01-01")
}
}
