% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranDownloads.R
\name{plot.cran_downloads}
\alias{plot.cran_downloads}
\title{Plot method for cranDownloads().}
\usage{
\method{plot}{cran_downloads}(x, graphics = NULL, points = "auto",
  log_count = FALSE, smooth = FALSE, se = FALSE, f = 1/3,
  r.version = FALSE, ...)
}
\arguments{
\item{x}{object.}

\item{graphics}{Character. NULL, "base" or "ggplot2".}

\item{points}{Character of Logical. Plot points. "auto", TRUE, FALSE.}

\item{log_count}{Logical. Logarithm of package downloads.}

\item{smooth}{Logical. Add smoother.}

\item{se}{Logical. Works only with graphics = "ggplot2".}

\item{f}{Numeric. stats::lowess() smoother window. For use with graphics = "base" only.}

\item{r.version}{Logical. Add R release dates.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R or ggplot2 plot.
}
\description{
Plot method for cranDownloads().
}
\examples{
\donttest{
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table")))
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
plot(cranDownloads(packages = "R", from = "2019-05-01", to = "2019-05-01"))
plot(cranDownloads(packages = "R", from = 2019))
}
}
