% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{use_seemingly_unrelated_regression}
\alias{use_seemingly_unrelated_regression}
\title{Bivariate regression for correlated observations}
\usage{
use_seemingly_unrelated_regression(
  param1_to_be_estimated,
  param2_to_be_estimated,
  dataset,
  indep_var,
  covariates1,
  covariates2,
  interaction1,
  interaction2
)
}
\arguments{
\item{param1_to_be_estimated}{parameter of interest}

\item{param2_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{covariates1}{list of covariates - for equation 1}

\item{covariates2}{list of covariates - for equation 2}

\item{interaction1}{boolean value to indicate interaction - for equation 1}

\item{interaction2}{boolean value to indicate interaction - for equation 2
false by default}
}
\value{
the results of the regression analysis
}
\description{
Bivariate regression for correlated observations
}
\examples{
\donttest{
datafile <- system.file("extdata", "sureg_data.csv", package = "packDAMipd")
dataset <- read.csv(datafile, stringsAsFactors = TRUE)
results_sureg <- use_seemingly_unrelated_regression("read", "math",
  dataset = dataset,
  indep_var = "female", covariates1 = c("as.numeric(ses)", "socst"),
  covariates2 = c("as.numeric(ses)", "science"), interaction1 = FALSE,
  interaction2 = FALSE
)
}
}
