% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_data.R
\name{crop_data}
\alias{crop_data}
\title{Crop precipitation data sets}
\usage{
crop_data(x, shp_path, autosave = FALSE)
}
\arguments{
\item{x}{a character string with the path to the data file. Or a RasterBrick.}

\item{shp_path}{a character string with the path to the ".shp" file.}

\item{autosave}{logical FALSE (default). If TRUE data will be automatically stored in the same location of the input file}
}
\value{
A cropped RasterBrick.
}
\description{
The function \code{crop_data} crops the data sets using a shapefile mask.
}
\examples{
\dontrun{
crop_data("gpcp_tp_mm_global_197901_202205_025_monthly.nc", "cze.shp",
autosave = TRUE)
crop_data("dummie.nc", "cze.shp", autosave = TRUE)
}
}
