% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCODE.R
\name{deltavar}
\alias{deltavar}
\title{Numeric estimation of variance of structural parameters by Delta method.}
\usage{
deltavar(data, time, ode.model,par.names,state.names,
        likelihood.fun, par.initial, basis.list, lambda,stepsize,y_stepsize,controls)
}
\arguments{
\item{data}{A data frame or a matrix contain observations from each dimension of the ODE model.}

\item{time}{A vector contain observation times or a matrix if time points are different between dimensions.}

\item{ode.model}{An R function that computes the time derivative of the ODE model given observations of states variable and structural parameters.}

\item{par.names}{The names of structural parameters defined in the 'ode.model'.}

\item{state.names}{The names of state variables defined in the 'ode.model'.}

\item{likelihood.fun}{A likelihood function passed to PCODE in case of that the error termsdevtools::document()do not have a Normal distribution.}

\item{par.initial}{Initial value of structural parameters to be optimized.}

\item{basis.list}{A list of basis objects for smoothing each dimension's observations. Can be the same or different across dimensions.}

\item{lambda}{Penalty parameter.}

\item{stepsize}{Stepsize used in estimating partial derivatives with respect to structural parameters for the Delta method.}

\item{y_stepsize}{Stepsize used in estimating partial derivatives with respect to observations for the Delta method.}

\item{controls}{A list of control parameters. Same as the controls in \code{pcode}.}
}
\value{
par.var The variance of structural parameters obtained by Delta method.
}
\description{
Obtaining variance of structural parameters by Delta method.
}
