% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WFSCapabilities.R
\docType{class}
\name{WFSCapabilities}
\alias{WFSCapabilities}
\title{WFSCapabilities}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Feature Service Get Capabilities document.
}
\description{
WFSCapabilities
}
\note{
Class used to read a \code{WFSCapabilities} document. The use of \code{WFSClient} is
recommended instead to benefit from the full set of capabilities associated to a WFS server.
}
\section{Methods}{

\describe{
 \item{\code{new(url, version, logger)}}{
   This method is used to instantiate a WFSGetCapabilities object
 }
 \item{\code{getFeatureTypes(pretty)}}{
   List the feature types available. If \code{pretty} is TRUE,
   the output will be an object of class \code{data.frame}
 }
 \item{\code{findFeatureTypeByName(name, exact)}}{
   Find feature type(s) by name.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GetCapabilities}
\keyword{OGC}
\keyword{WFS}
