% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\alias{score.OwlGaussian}
\alias{score.OwlBinomial}
\alias{score.OwlMultinomial}
\alias{score.OwlPoisson}
\title{Compute one of several loss metrics on a new data set}
\usage{
score(object, x, y, measure)

\method{score}{OwlGaussian}(object, x, y, measure = c("mse", "mae"))

\method{score}{OwlBinomial}(object, x, y, measure = c("mse", "mae", "deviance", "misclass", "auc"))

\method{score}{OwlMultinomial}(object, x, y, measure = c("mse", "mae", "deviance", "misclass"))

\method{score}{OwlPoisson}(object, x, y, measure = c("mse", "mae"))
}
\arguments{
\item{object}{an object of class \code{"Owl"}}

\item{x}{feature matrix}

\item{y}{response}

\item{measure}{type of target measure. \code{"mse"} returns mean squared error.
\code{"mae"} returns mean absolute error, \code{"misclass"} returns
misclassification rate, and \code{"auc"} returns area under the ROC curve.}
}
\value{
The measure along the regularization path depending on the
value in \code{measure}.
}
\description{
This function is a unified interface to return various types of loss for a
model fit with \code{\link[=owl]{owl()}}.
}
\examples{
x <- subset(infert, select = c("induced", "age", "pooled.stratum"))
y <- infert$case

fit <- owl(x, y, family = "binomial")
score(fit, x, y, measure = "auc")
}
