% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outersupport.R
\name{BFGS_std}
\alias{BFGS_std}
\title{BFGS standard}
\usage{
BFGS_std(funcw, parlist, B = NULL, lr = 0.1, ..., verbose = 0)
}
\arguments{
\item{funcw}{An object to optimize}

\item{parlist}{An initial point as a list}

\item{B}{An initial Hessian to start from}

\item{lr}{An initial learning rate to start from}

\item{...}{additional parameters passed to \code{funcw}}

\item{verbose}{an integer from 0-3 where larger prints more information}
}
\value{
a list of information from optimization, with the value stored in
\code{parlist}
}
\description{
Do generic minimization of a function \code{funcw} that takes
a list parlist using the "Broyden-Fletcher-Goldfarb-Shanno" (BFGS) algorithm.
Useful for hyperparameter optimization because it handles infinite returns
fairly easily.
}
