% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemblQuery.R
\name{chemblQuery}
\alias{chemblQuery}
\title{Retrieve ChEMBL data for a specified gene and disease.}
\usage{
chemblQuery(ensemblId, efoId, size = 10, cursor = NULL)
}
\arguments{
\item{ensemblId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000169174).}

\item{efoId}{Character: EFO ID of the disease (e.g., EFO_0004911).}

\item{size}{Integer: Number of records to retrieve (default: 10).}

\item{cursor}{Character: Cursor for pagination (default: NULL).}
}
\value{
Returns a data frame containing ChEMBL data for the specified gene and disease.
}
\description{
This function queries the Open Targets Genetics GraphQL API to retrieve ChEMBL data
for a specified gene and disease, including evidence from the ChEMBL datasource.
}
\examples{
\dontrun{
result <- chemblQuery(ensemblId = "ENSG00000169174",
 efoId = "EFO_0004911", size = 10)
result <- chemblQuery(ensemblId = "ENSG00000169174",
 efoId = "EFO_0004911", size = 10, cursor = NULL)
}
}
