% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-osm-map.R
\name{make_osm_map}
\alias{make_osm_map}
\title{make_osm_map}
\usage{
make_osm_map(bbox, osm_data, structures = osm_structures(),
  dat_prefix = "dat_")
}
\arguments{
\item{bbox}{The bounding box for the map.  A 2-by-2 matrix of 4 elements with
columns of min and max values, and rows of x and y values.  If \code{NULL},
\code{bbox} is taken from the largest extent of OSM objects in
\code{osm_data}.}

\item{osm_data}{A list of OSM objects as returned from
\code{\link{extract_osm_objects}}.  These objects may be included in the plot
without downloading. These should all be named with the stated
\code{dat_prefix} and have suffixes as given in \code{structures}.}

\item{structures}{A \code{data.frame} specifying types of OSM structures as
returned from \code{\link{osm_structures}}, and potentially modified to alter
lists of structures to be plotted, and their associated colours. Objects are
overlaid on plot according to the order given in \code{structures}.}

\item{dat_prefix}{Prefix for data structures (default \code{dat_}). Final data
structures are created by appending the suffixes from
\code{\link{osm_structures}}.}
}
\value{
List of two components: 
\enumerate{
  \item List of OSM structures each as
     \code{Spatial(Points/Lines/Polygons)DataFrame} and appended to
     \code{osm_data} (which is \code{NULL} by default), and 
  \item The \code{map} as a \code{ggplot2} object
}
}
\description{
Makes an entire OSM map for the given bbox using the submitted data, or by
downloading data if none submitted. This is a convenience function enabling
an entire map to be produced according to the graphical format specified with
the \code{structures} argument.
}
\section{Note}{

If \code{osm_data} is not given, then data will be downloaded, which can take
some time.  Progress is dumped to screen.
}

\examples{
structures <- c ('highway', 'park')
structs <- osm_structures (structures = structures, col_scheme = 'light')
# make_osm_map returns potentially modified list of data using the provided
# 'london' data for highways and parks.
dat <- make_osm_map (osm_data = london, structures = structs)
# or download data automatically using a defined bounding boox
bbox <- get_bbox (c(-0.15,51.5,-0.10,51.52))
\dontrun{
dat <- make_osm_map (bbox = bbox, structures = structs)
print_osm_map (dat$map)
}
}
\seealso{
\code{\link{osm_basemap}}, \code{\link{add_osm_objects}}.
}
