/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality.fishing;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.FishingMortality;
import fr.ird.osmose.process.mortality.fishing.AbstractFishingMortality;
import fr.ird.osmose.util.timeseries.ByYearTimeSeries;
import fr.ird.osmose.util.timeseries.SingleTimeSeries;

public class ByYearBySeasonFishingMortality
extends AbstractFishingMortality {
    private double[] annualF;
    private double[] annualCatches;
    private double[] season;
    private int recruitmentAge;
    private float recruitmentSize;
    private final FishingMortality.Type type;
    private double fishableBiomass;

    public ByYearBySeasonFishingMortality(int rank, Species species, FishingMortality.Type type) {
        super(rank, species);
        this.type = type;
    }

    @Override
    public void init() {
        String filename;
        int nStepYear = this.getConfiguration().getNStepYear();
        int iSpec = this.getIndexSpecies();
        switch (this.type) {
            case RATE: {
                filename = this.getConfiguration().getFile("mortality.fishing.rate.byYear.file.sp" + iSpec);
                ByYearTimeSeries yts = new ByYearTimeSeries(this.getRank());
                yts.read(filename);
                this.annualF = yts.getValues();
                this.annualCatches = new double[this.annualF.length];
                break;
            }
            case CATCHES: {
                filename = this.getConfiguration().getFile("mortality.fishing.catches.byYear.file.sp" + iSpec);
                ByYearTimeSeries yts = new ByYearTimeSeries(this.getRank());
                yts.read(filename);
                this.annualCatches = yts.getValues();
                this.annualF = new double[this.annualCatches.length];
            }
        }
        if (!this.getConfiguration().isNull("mortality.fishing.recruitment.age.sp" + iSpec)) {
            float age = this.getConfiguration().getFloat("mortality.fishing.recruitment.age.sp" + iSpec);
            this.recruitmentAge = Math.round(age * (float)nStepYear);
            this.recruitmentSize = 0.0f;
        } else if (!this.getConfiguration().isNull("mortality.fishing.recruitment.size.sp" + iSpec)) {
            this.recruitmentSize = this.getConfiguration().getFloat("mortality.fishing.recruitment.size.sp" + iSpec);
            this.recruitmentAge = 0;
        } else {
            this.recruitmentAge = 0;
            this.recruitmentSize = 0.0f;
            this.getSimulation().warning("Could not find any fishing recruitment threshold (neither age nor size) for species {0}. Osmose assumes every school can be catched.", this.getSpecies().getName());
        }
        SingleTimeSeries sts = new SingleTimeSeries(this.getRank());
        filename = this.getConfiguration().getFile("mortality.fishing.season.distrib.file.sp" + iSpec);
        sts.read(filename, nStepYear, nStepYear);
        this.season = sts.getValues();
    }

    @Override
    public double getRate(School school) {
        return school.getAgeDt() >= this.recruitmentAge && school.getLength() >= this.recruitmentSize ? this.annualF[this.getSimulation().getYear()] * this.season[this.getSimulation().getIndexTimeYear()] : 0.0;
    }

    @Override
    public double getCatches(School school) {
        if (this.isFishable(school) && this.fishableBiomass > 0.0) {
            return school.getInstantaneousBiomass() / this.fishableBiomass * this.annualCatches[this.getSimulation().getYear()] * this.season[this.getSimulation().getIndexTimeYear()];
        }
        return 0.0;
    }

    @Override
    public void assessFishableBiomass() {
        this.fishableBiomass = 0.0;
        for (School school : this.getSchoolSet().getSchools(this.getSpecies(), false)) {
            if (school.isUnlocated() || !this.isFishable(school)) continue;
            this.fishableBiomass += school.getInstantaneousBiomass();
        }
    }

    private boolean isFishable(School school) {
        return school.getAgeDt() >= this.recruitmentAge && school.getLength() >= this.recruitmentSize;
    }
}

