\name{osmsource_osmosis}
\alias{osmsource_osmosis}
\title{Osmosis OSM data source}
\usage{
  osmsource_osmosis(file, osmosis = "osmosis")
}
\arguments{
  \item{file}{The file name (and path) of the planet dump}

  \item{osmosis}{The path to the osmosis application}
}
\description{
  Planet dumps as OSM data source through the osmosis
  command line Java application.
}
\details{
  Osmosis is a command line Java application for processing
  OSM data. It allows, among other things, to extract data
  inside a bounding box or polygon from so called planet
  dumps. The usage of this source requires an installed
  osmosis; see
  \url{http://wiki.openstreetmap.org/wiki/Osmosis}.
}
\section{Supported request elements}{
  \describe{

  \item{Bounding box:}{

  Use \code{\link{bbox}} or \code{\link{center_bbox}} to
  retrieve:

  \itemize{

  \item all nodes that are inside a given bounding box and
  any relations that reference them;

  \item all ways that reference at least one node that is
  inside a given bounding box, any relations that reference
  them [the ways], and any nodes outside the bounding box
  that the ways may reference;

  \item all relations that reference one of the nodes or
  ways included due to the above rules (does not apply
  recursively); }

  }

  }
}
\references{
  \url{http://wiki.openstreetmap.org/wiki/Osmosis}
}
\seealso{
  \code{\link{get_osm}}, \code{\link{bbox}},
  \code{\link{osm_descriptors}}

  Other osmsource: \code{\link{osmsource_api}},
  \code{\link{osmsource_file}}
}

