% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{set_os_key}
\alias{set_os_key}
\alias{get_os_key}
\alias{has_os_key}
\title{Set credentials for OS Data Hub}
\usage{
set_os_key(apikey)

get_os_key()

has_os_key()
}
\arguments{
\item{apikey}{(character) Required project API key.}
}
\value{
(Invisibly) A logical value from \code{Sys.setenv} whether an
environment variable was set.

If an environment variable named \code{OS_API_KEY} is present, the
character string for the variable is returned.

If an environment variable named \code{OS_API_KEY} is present, then
\code{TRUE}, else this function returns \code{FALSE}.
}
\description{
In order to use the Ordnance Survey Data Hub a valid API key is required.
}
\details{
Stores the user provided character string in an environment variable
named \code{OS_API_KEY}. No validation of the key is applied when storing.
To obtain a key go to \url{https://osdatahub.os.uk/}.

Be careful not to reveal secrets including API keys. This function
may print the API key to the console. It is used internally by the
\code{osdatahub} query functions.

Primarily this is used internally to control when examples are
executed.
}
\examples{
set_os_key('my-api-key')

\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
my_api_key <- get_os_key()
\dontshow{\}) # examplesIf}
has_os_key()

}
