% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitpix.R, R/zzz_niftiImage.R
\docType{methods}
\name{bitpix-methods}
\alias{bitpix-methods}
\alias{bitpix-methods,}
\alias{bitpix}
\alias{bitpix,nifti-method}
\alias{bitpix,anlz-method}
\alias{bitpix<-}
\alias{bitpix<-,nifti-method}
\alias{bitpix<-,anlz-method}
\alias{bitpix,niftiImage-method}
\title{Extract Image Attribute \code{bitpix}}
\usage{
bitpix(object)

\S4method{bitpix}{nifti}(object)

\S4method{bitpix}{anlz}(object)

bitpix(object) <- value

\S4method{bitpix}{nifti}(object) <- value

\S4method{bitpix}{anlz}(object) <- value

\S4method{bitpix}{niftiImage}(object)
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{bitpix} field.}
}
\description{
Methods that act on the \code{bitpix} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
bitpix(img)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
