% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_img.R
\name{calibrateImage}
\alias{calibrateImage}
\alias{cal_img}
\title{Set Minimum/Maximum Values for NIfTI data}
\usage{
calibrateImage(img, infok = TRUE)

cal_img(img, infok = TRUE)
}
\arguments{
\item{img}{is a \code{nifti} object.}

\item{infok}{is a logical value whether or not \code{Inf} and 
\code{-Inf} are acceptable (default = \code{TRUE}).  If \code{FALSE} 
and max or min is infinity, then \code{cal_min} or \code{cal_max} is 
set to infinity (negative or positive), respectively.}
}
\value{
An object of class \code{nifti}.
}
\description{
Rescales image \code{cal_max} and \code{cal_min} slots to 
be the max and min, respectively, of an object of class nifti, with 
\code{na.rm = TRUE}.  This is so that when images are rendered/written, 
the values correspond to those in the array (stored in \code{.Data} slot) 
are plotted on correct greyscale and no error is given by \code{writeNIfTI}.
}
\author{
John Muschelli \email{muschellij2@gmail.com}
}
