% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsuml2.R
\name{zsuml2}
\alias{zsuml2}
\alias{zsuml2,loca.p-method}
\alias{zsuml2gra}
\alias{zsuml2gra,loca.p-method}
\title{zsuml2 and zsuml2gra at orloca package}
\usage{
zsuml2(o, x = 0, y = 0)
}
\arguments{
\item{o}{An object of \code{loca.p} class.}

\item{x}{The x coordinate of the point to be evaluated.}

\item{y}{The y coordinate of the point to be evaluated.}

\item{partial}{If (x,y) is a demand point \code{partial=T} means ignore such point to compute the gradient. This option is mainly for internal use.}
}
\value{
\code{zsuml2} returns the objective function of the min-sum location problem, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, where \eqn{d(a_i, (x,y))} gives the euclidean distances between \eqn{a_i} and the point \eqn{(x,y)}.  \code{zsumgra} returns the gradient vector of the function \code{zsum}.
}
\description{
\code{zsum} and \code{zsumgra} functions for the Euclidean norm (\eqn{l_2}). Mainly for internal use.
}
\seealso{
See also \code{\link{orloca-package}}, \code{\link{zsum}}, \code{\link{zsumgra}} and \code{\link{zsummin}}.
}
\keyword{classes}
\keyword{internal}
\keyword{optimize}
