\name{zsumlp}
\alias{zsumlp}
\alias{zsumlp,loca.p-method}
\alias{zsumlpgra}
\alias{zsumlpgra,loca.p-method}
\encoding{UTF-8}

\title{zsumlp y zsumlpgra del paquete orloca}
\description{Las funciones zsum y zsumgra con norma
  \eqn{l_p}. Principalmente para uso interno.}
\usage{
zsumlp(o, x=0, y=0, p=2)
zsumlpgra(o, x=0, y=0, p=2, partial=F)
}
\arguments{
  \item{o}{Un objeto de clase \code{loca.p}.}
  \item{x}{La coordenada x del punto a ser evaluado.}
  \item{y}{La coordenada y del punto a ser evaluado.}
  \item{p}{La norma \eqn{l_p} a usar.}
  \item{partial}{Si (x,y) es un punto de demanda, \code{partial=T}
    significa que se ignore dicho punto para el \enc{cálculo}{calculo} del
    gradiente. Principalmente para uso interno.}
}
\value{
  \code{zsumlp} devuelve el valor de la \enc{función}{funcion} objetivo
  del problema de \enc{localización}{localizacion} min-sum con norma
  \eqn{l_p}, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, donde \eqn{d(a_i,
    (x,y))} es la distancia entre \eqn{a_i} y el punto \eqn{(x,y)}
  usando la norma \eqn{l_p}. 

  \code{zsumlpgra} devuelve el vector gradiente de la \enc{función}{funcion} \code{zsumlp}.
}
\details{
Si \eqn{p<1} entonces \eqn{l_p} no es una norma, por tanto, \enc{sólo}{solo} valores
\eqn{p>=1} son \enc{válidos}{validos}.
}
\note{Dado que \eqn{l_2} es la norma \enc{euclídea}{euclidea}, cuando \eqn{p=2}
  \code{zsumlp} es igual a \code{zsum}, y \code{zsumlpgra} es igual a
  \code{zsumgra}. Pero los \enc{cálculos}{calculos} necesarios son
  mayors para la primera forma.}

\keyword{classes}
\keyword{optimize}
\seealso{
  \enc{Véase}{Vease} \code{\link{zsum}}, \code{\link{orloca.es-package}} y \code{\link{zsumlpmin}}.
  }